/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.storagemonitor.AutocraftingStorageMonitorExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorInsertTracker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMonitorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
PreviewProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageMonitorBlockEntity.class);
    private static final String TAG_CLIENT_FILTER = "cf";
    private static final String TAG_CLIENT_AMOUNT = "ca";
    private static final String TAG_CLIENT_ACTIVE = "cac";
    private final FilterWithFuzzyMode filter;
    private final RateLimiter displayUpdateRateLimiter = RateLimiter.create((double)0.25);
    private final StorageMonitorInsertTracker insertTracker = new StorageMonitorInsertTracker();
    private long currentAmount;
    private boolean currentlyActive;
    private long lastExtractTime;

    public StorageMonitorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getStorageMonitor(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getStorageMonitor().getEnergyUsage()));
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(1);
        this.filter = FilterWithFuzzyMode.create(resourceContainer, () -> {
            this.setChanged();
            this.sendDisplayUpdate();
        });
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.level == null) {
            return;
        }
        this.trySendDisplayUpdate(this.level);
    }

    private void trySendDisplayUpdate(Level level) {
        long amount = this.getAmount();
        boolean active = ((SimpleNetworkNode)this.mainNetworkNode).isActive();
        if ((amount != this.currentAmount || active != this.currentlyActive) && this.displayUpdateRateLimiter.tryAcquire()) {
            this.sendDisplayUpdate(level, amount, active);
        }
    }

    private long getAmount() {
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return 0L;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return 0L;
        }
        return this.getAmount(network, configuredResource);
    }

    private long getAmount(Network network, ResourceKey configuredResource) {
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        if (!this.filter.isFuzzyMode() || !(rootStorage instanceof FuzzyRootStorage)) {
            return rootStorage.get(configuredResource);
        }
        FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
        return fuzzyRootStorage.getFuzzy(configuredResource).stream().mapToLong(rootStorage::get).sum();
    }

    public void extract(ServerPlayer player) {
        if (this.level == null) {
            return;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return;
        }
        boolean extracted = this.doExtract(this.level, (Player)player, configuredResource, network);
        if (extracted) {
            this.lastExtractTime = System.currentTimeMillis();
        }
        if (!extracted && System.currentTimeMillis() - this.lastExtractTime > 250L) {
            this.tryAutocrafting(player, network, configuredResource);
        }
    }

    private void tryAutocrafting(ServerPlayer player, Network network, PlatformResourceKey configuredResource) {
        boolean autocraftable = network.getComponent(AutocraftingNetworkComponent.class).getOutputs().contains(configuredResource);
        if (autocraftable) {
            Platform.INSTANCE.getMenuOpener().openMenu(player, new AutocraftingStorageMonitorExtendedMenuProvider(configuredResource, this));
        }
    }

    private boolean doExtract(Level level, Player player, ResourceKey configuredResource, Network network) {
        boolean success = RefinedStorageApi.INSTANCE.getStorageMonitorExtractionStrategy().extract(configuredResource, !player.isShiftKeyDown(), player, new PlayerActor(player), network);
        if (!success) {
            return false;
        }
        this.sendDisplayUpdate();
        level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        return true;
    }

    public void insert(Player player, InteractionHand hand) {
        if (this.level != null && this.doInsert(player, hand)) {
            this.sendDisplayUpdate();
        }
    }

    private boolean doInsert(Player player, InteractionHand hand) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return false;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return false;
        }
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.isEmpty()) {
            return this.doInsertAll(player);
        }
        return this.doInsert(player, hand, heldStack, configuredResource, network);
    }

    private boolean doInsert(Player player, InteractionHand hand, ItemStack heldStack, ResourceKey configuredResource, Network network) {
        return RefinedStorageApi.INSTANCE.getStorageMonitorInsertionStrategy().insert(configuredResource, heldStack, new PlayerActor(player), network).map(result -> {
            this.insertTracker.trackInsertedItem(player.getGameProfile(), heldStack);
            player.setItemInHand(hand, result);
            return true;
        }).orElse(false);
    }

    private boolean doInsertAll(Player player) {
        return this.insertTracker.getLastInsertedItem(player.getGameProfile()).map(item -> this.doInsertAll(player, (ItemResource)item)).orElse(false);
    }

    private boolean doInsertAll(Player player, ItemResource lastInsertedItem) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return false;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            success |= this.tryInsertSlot(player, lastInsertedItem, i, configuredResource, network);
        }
        return success;
    }

    private boolean tryInsertSlot(Player player, ItemResource lastInsertedItem, int inventorySlotIndex, ResourceKey configuredResource, Network network) {
        ItemStack slot = player.getInventory().getItem(inventorySlotIndex);
        if (slot.isEmpty()) {
            return false;
        }
        ItemResource itemInSlot = ItemResource.ofItemStack(slot);
        if (!itemInSlot.equals(lastInsertedItem)) {
            return false;
        }
        return RefinedStorageApi.INSTANCE.getStorageMonitorInsertionStrategy().insert(configuredResource, slot, new PlayerActor(player), network).map(result -> {
            player.getInventory().setItem(inventorySlotIndex, result);
            return true;
        }).orElse(false);
    }

    public boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    @Nullable
    public PlatformResourceKey getConfiguredResource() {
        return this.filter.getFilterContainer().getResource(0);
    }

    public long getCurrentAmount() {
        return this.currentAmount;
    }

    public boolean isCurrentlyActive() {
        return this.currentlyActive;
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_CLIENT_FILTER) && tag.contains(TAG_CLIENT_AMOUNT) && tag.contains(TAG_CLIENT_ACTIVE)) {
            this.filter.getFilterContainer().fromTag(tag.getCompound(TAG_CLIENT_FILTER), provider);
            this.currentAmount = tag.getLong(TAG_CLIENT_AMOUNT);
            this.currentlyActive = tag.getBoolean(TAG_CLIENT_ACTIVE);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.STORAGE_MONITOR);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new StorageMonitorContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.put(TAG_CLIENT_FILTER, (Tag)this.filter.getFilterContainer().toTag(provider));
        tag.putLong(TAG_CLIENT_AMOUNT, this.currentAmount);
        tag.putBoolean(TAG_CLIENT_ACTIVE, this.currentlyActive);
        return tag;
    }

    private void sendDisplayUpdate() {
        if (this.level == null) {
            return;
        }
        this.sendDisplayUpdate(this.level, this.getAmount(), ((SimpleNetworkNode)this.mainNetworkNode).isActive());
    }

    private void sendDisplayUpdate(Level level, long amount, boolean active) {
        this.currentAmount = amount;
        this.currentlyActive = active;
        LOGGER.debug("Sending display update for storage monitor {} with amount {}", (Object)this.worldPosition, (Object)amount);
        PlatformUtil.sendBlockUpdateToClient(level, this.worldPosition);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getPreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getTreePreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getMaxAmount(resource, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    @Override
    public Optional<TaskId> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return Optional.empty();
        }
        return network.getComponent(AutocraftingNetworkComponent.class).startTask(resource, amount, actor, notify, cancellationToken);
    }
}

