/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorage;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.storage.ErrorHandlingListCodec;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class StorageCodecs {
    private static final StreamCodec<RegistryFriendlyByteBuf, TrackedResource> TRACKED_RESOURCE_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TrackedResource::getSourceName, (StreamCodec)ByteBufCodecs.VAR_LONG, TrackedResource::getTime, TrackedResource::new);
    private static final Codec<StorageChangedByAt> CHANGED_BY_AT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("changedBy").forGetter(StorageChangedByAt::changedBy), (App)Codec.LONG.fieldOf("changedAt").forGetter(StorageChangedByAt::changedAt)).apply((Applicative)instance, StorageChangedByAt::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<TrackedResource>> TRACKED_RESOURCE_OPTIONAL_STREAM_CODEC = ByteBufCodecs.optional(TRACKED_RESOURCE_STREAM_CODEC);

    private StorageCodecs() {
    }

    static <T extends ResourceKey> MapCodec<StorageData<T>> sameTypeStorageData(Codec<T> resourceCodec) {
        Codec storageResourceCodec = RecordCodecBuilder.create(instance -> instance.group((App)resourceCodec.fieldOf("resource").forGetter(StorageResource::resource), (App)Codec.LONG.fieldOf("amount").forGetter(StorageResource::amount), (App)Codec.optionalField((String)"changed", CHANGED_BY_AT_CODEC, (boolean)false).forGetter(StorageResource::changed)).apply((Applicative)instance, StorageResource::new));
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.optionalField((String)"capacity", (Codec)Codec.LONG, (boolean)false).forGetter(StorageData::capacity), (App)new ErrorHandlingListCodec(storageResourceCodec).fieldOf("resources").forGetter(StorageData::resources)).apply((Applicative)instance, StorageData::new));
    }

    record StorageChangedByAt(String changedBy, long changedAt) {
        private static StorageChangedByAt ofTrackedResource(TrackedResource trackedResource) {
            return new StorageChangedByAt(trackedResource.getSourceName(), trackedResource.getTime());
        }
    }

    record StorageResource<T extends ResourceKey>(T resource, long amount, Optional<StorageChangedByAt> changed) {
    }

    record StorageData<T extends ResourceKey>(Optional<Long> capacity, List<StorageResource<T>> resources) {
        static <T extends ResourceKey> StorageData<T> empty(@Nullable Long capacity) {
            return new StorageData<T>(Optional.ofNullable(capacity), List.of());
        }

        static <T extends ResourceKey> StorageData<T> ofSameTypeStorage(Storage storage, Predicate<ResourceKey> valid, Function<ResourceKey, T> caster) {
            Optional<Long> optional;
            if (storage instanceof LimitedStorage) {
                LimitedStorage limitedStorage = (LimitedStorage)storage;
                optional = Optional.of(limitedStorage.getCapacity());
            } else {
                optional = Optional.empty();
            }
            Optional<Long> capacity = optional;
            List<StorageResource<T>> resources = storage.getAll().stream().filter(resourceAmount -> valid.test(resourceAmount.resource())).map(resourceAmount -> StorageData.getResource(storage, caster, resourceAmount)).toList();
            return new StorageData<T>(capacity, resources);
        }

        private static <T extends ResourceKey> StorageResource<T> getResource(Storage storage, Function<ResourceKey, T> caster, ResourceAmount resourceAmount) {
            return new StorageResource<ResourceKey>((ResourceKey)caster.apply(resourceAmount.resource()), resourceAmount.amount(), StorageData.getChanged(storage, resourceAmount));
        }

        private static Optional<StorageChangedByAt> getChanged(Storage storage, ResourceAmount resourceAmount) {
            if (!(storage instanceof TrackedStorage)) {
                return Optional.empty();
            }
            TrackedStorage trackedStorage = (TrackedStorage)storage;
            return trackedStorage.findTrackedResourceByActorType(resourceAmount.resource(), PlayerActor.class).map(StorageChangedByAt::ofTrackedResource);
        }
    }
}

