/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.security.SecurityCardData;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

class FallbackSecurityCardExtendedMenuProvider
extends AbstractSecurityCardExtendedMenuProvider<SecurityCardData> {
    @Nullable
    private final Component name;
    private final SlotReference slotReference;

    FallbackSecurityCardExtendedMenuProvider(@Nullable Component name, SlotReference slotReference, SecurityPolicy securityPolicy, Set<PlatformPermission> dirtyPermissions) {
        super(securityPolicy, dirtyPermissions);
        this.name = name;
        this.slotReference = slotReference;
    }

    @Override
    public SecurityCardData getMenuData() {
        return new SecurityCardData(this.slotReference, this.getDataPermissions());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, SecurityCardData> getMenuCodec() {
        return SecurityCardData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        return this.name == null ? ContentNames.FALLBACK_SECURITY_CARD : this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new FallbackSecurityCardContainerMenu(syncId, inventory, this.slotReference);
    }
}

