/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlock;
import com.refinedmods.refinedstorage.common.grid.CraftingGridBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingGridBlock
extends AbstractGridBlock<CraftingGridBlock, BaseBlockItem>
implements BlockItemProvider<BaseBlockItem> {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "crafting_grid.help");
    private static final AbstractBlockEntityTicker<CraftingGridBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getCraftingGrid, ACTIVE);

    public CraftingGridBlock(DyeColor color, MutableComponent name) {
        super(name, color);
    }

    @Override
    public BlockColorMap<CraftingGridBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getCraftingGrid();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CraftingGridBlockEntity(pos, state);
    }

    @Nullable
    public <O extends BlockEntity> BlockEntityTicker<O> getTicker(Level level, BlockState blockState, BlockEntityType<O> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

