/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.constructordestructor.AbstractDestructorBlockEntity;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorDestructorPropertyTypes;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractSimpleFilterContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DestructorContainerMenu
extends AbstractSimpleFilterContainerMenu<AbstractDestructorBlockEntity> {
    private static final MutableComponent FILTER_HELP = IdentifierUtil.createTranslation("gui", "destructor.filter_help");
    private final Predicate<Player> stillValid;

    public DestructorContainerMenu(int syncId, Inventory playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getDestructor(), syncId, playerInventory.player, resourceContainerData, UpgradeDestinations.DESTRUCTOR, (Component)FILTER_HELP);
        this.stillValid = p -> true;
    }

    DestructorContainerMenu(int syncId, Player player, AbstractDestructorBlockEntity destructor, ResourceContainer resourceContainer, UpgradeContainer upgradeContainer) {
        super(Menus.INSTANCE.getDestructor(), syncId, player, resourceContainer, upgradeContainer, destructor, (Component)FILTER_HELP);
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)destructor, (Player)p);
    }

    @Override
    protected void registerClientProperties() {
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.registerProperty(new ClientProperty<FilterMode>(PropertyTypes.FILTER_MODE, FilterMode.BLOCK));
        this.registerProperty(new ClientProperty<Boolean>(ConstructorDestructorPropertyTypes.PICKUP_ITEMS, false));
    }

    @Override
    protected void registerServerProperties(AbstractDestructorBlockEntity blockEntity) {
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.registerProperty(new ServerProperty<FilterMode>(PropertyTypes.FILTER_MODE, blockEntity::getFilterMode, blockEntity::setFilterMode));
        this.registerProperty(new ServerProperty<Boolean>(ConstructorDestructorPropertyTypes.PICKUP_ITEMS, blockEntity::isPickupItems, blockEntity::setPickupItems));
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }
}

