/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentProvider;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class AugmentItem
extends BaseItem
implements IAugmentProvider {
    private final Augment augment;

    public AugmentItem(Augment augment) {
        this.augment = augment;
    }

    public Component getName(ItemStack stack) {
        return Localizable.of((String)"item.mysticalagriculture.augment").args(new Object[]{this.augment.getDisplayName()}).build();
    }

    public Component getDescription() {
        return this.getName(ItemStack.EMPTY);
    }

    public boolean isFoil(ItemStack stack) {
        return this.augment.hasEffect();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.augment.getTier()));
        tooltip.add((Component)this.augment.getDescriptionDisplayText());
        if (this.augment.hasSetBonus()) {
            tooltip.add((Component)ModTooltips.SET_BONUS.args(new Object[]{this.augment.getSetBonusDisplayText()}).build());
        }
        if (flag.isAdvanced()) {
            tooltip.add((Component)ModTooltips.AUGMENT_ID.args(new Object[]{this.augment.getId().toString()}).color(ChatFormatting.DARK_GRAY).build());
        }
    }

    @Override
    public Augment getAugment() {
        return this.augment;
    }
}

