/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AttackAOEAugment
extends Augment {
    private final int amplifier;

    public AttackAOEAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.SWORD), AttackAOEAugment.getColor(0xFF0000, tier), AttackAOEAugment.getColor(0x700000, tier));
        this.amplifier = amplifier;
    }

    @Override
    public boolean onHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!player.getCooldowns().isOnCooldown(stack.getItem())) {
                Level level = player.level();
                List entities = level.getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.5 * (double)this.amplifier, 0.25 * (double)this.amplifier, 1.5 * (double)this.amplifier));
                for (LivingEntity aoeEntity : entities) {
                    if (aoeEntity == player || aoeEntity == target || player.isAlliedTo((Entity)target)) continue;
                    aoeEntity.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                    aoeEntity.hurt(level.damageSources().playerAttack(player), 5.0f + 5.0f * (float)this.amplifier);
                }
                player.getCommandSenderWorld().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                player.sweepAttack();
            }
            return true;
        }
        return false;
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

