/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.utils;

import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class ManualRecipeRef {
    private final ItemStack output;
    private final PositionedItemStack[] layout;
    private final ResourceLocation recipeName;

    public ManualRecipeRef(ItemStack output) {
        this.output = Objects.requireNonNull(output);
        this.layout = null;
        this.recipeName = null;
    }

    public ManualRecipeRef(PositionedItemStack[] layout) {
        this.output = null;
        this.layout = Objects.requireNonNull(layout);
        this.recipeName = null;
    }

    public ManualRecipeRef(ResourceLocation recipeName) {
        this.output = null;
        this.layout = null;
        this.recipeName = Objects.requireNonNull(recipeName);
    }

    public boolean isLayout() {
        return this.layout != null;
    }

    public PositionedItemStack[] getLayout() {
        return Objects.requireNonNull(this.layout);
    }

    public boolean isResult() {
        return this.output != null;
    }

    public ItemStack getResult() {
        return Objects.requireNonNull(this.output);
    }

    public boolean isRecipeName() {
        return this.recipeName != null;
    }

    public ResourceLocation getRecipeName() {
        return Objects.requireNonNull(this.recipeName);
    }

    public <C extends RecipeInput, R extends Recipe<C>> void forEachMatchingRecipe(RecipeType<R> type, Consumer<R> out) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        if (this.isRecipeName()) {
            recipeManager.byKey(this.getRecipeName()).ifPresent(recipeHolder -> out.accept(recipeHolder.value()));
        } else {
            for (RecipeHolder recipe : recipeManager.getAllRecipesFor(type)) {
                if (!ManualUtils.stackMatchesObject(recipe.value().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), this.getResult())) continue;
                out.accept(recipe.value());
            }
        }
    }
}

