/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageShaderManual(MessageType key, List<ResourceLocation> args) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageShaderManual> ID = IMessage.createType("shader_manual");
    public static final StreamCodec<ByteBuf, MessageShaderManual> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper(i -> MessageType.values()[i], Enum::ordinal), MessageShaderManual::key, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), MessageShaderManual::args, MessageShaderManual::new);

    public MessageShaderManual(MessageType key, ResourceLocation ... args) {
        this(key, Arrays.asList(args));
    }

    @Override
    public void process(IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            ServerPlayer player = IMessage.serverPlayer(context);
            UUID playerId = player.getUUID();
            context.enqueueWork(() -> {
                if (this.key == MessageType.SYNC) {
                    ResourceLocation[] ss = (ResourceLocation[])ShaderRegistry.receivedShaders.get((Object)playerId).stream().filter(Objects::nonNull).toArray(ResourceLocation[]::new);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MessageShaderManual(MessageType.SYNC, ss), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (this.key == MessageType.UNLOCK && !this.args.isEmpty()) {
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.args.get(0));
                } else if (this.key == MessageType.SPAWN && !this.args.isEmpty()) {
                    ItemStack shaderStack;
                    ItemEntity entityitem;
                    if (!player.getAbilities().instabuild) {
                        IngredientUtils.consumePlayerIngredient((Player)player, ShaderRegistry.shaderRegistry.get((Object)this.args.get((int)0)).replicationCost.get());
                    }
                    if ((entityitem = player.drop(shaderStack = ShaderRegistry.makeShaderStack(this.args.get(0)), false)) != null) {
                        entityitem.setNoPickUpDelay();
                        entityitem.setThrower((Entity)player);
                    }
                }
            });
        } else {
            context.enqueueWork(() -> {
                Player player;
                if (this.key == MessageType.SYNC && (player = ImmersiveEngineering.proxy.getClientPlayer()) != null) {
                    UUID name = player.getUUID();
                    for (ResourceLocation shader : this.args) {
                        if (shader == null) continue;
                        ShaderRegistry.receivedShaders.put((Object)name, (Object)shader);
                    }
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static enum MessageType {
        SYNC,
        UNLOCK,
        SPAWN;

    }
}

