/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer;

import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class MixingProcess
extends MultiblockProcessInMachine<MixerRecipe> {
    private final MultiFluidTank tank;

    public MixingProcess(RecipeHolder<MixerRecipe> recipe, MultiFluidTank tank, int ... inputSlots) {
        super(recipe, inputSlots);
        this.tank = tank;
    }

    public MixingProcess(BiFunction<Level, ResourceLocation, MixerRecipe> getRecipe, CompoundTag data, MultiFluidTank tank) {
        super(getRecipe, data);
        this.tank = tank;
    }

    @Override
    protected List<FluidStack> getRecipeFluidOutputs(Level level) {
        return Collections.emptyList();
    }

    @Override
    protected List<SizedFluidIngredient> getRecipeFluidInputs(ProcessContext.ProcessContextInMachine<MixerRecipe> context, Level level) {
        return Collections.emptyList();
    }

    @Override
    public void doProcessTick(ProcessContext.ProcessContextInMachine<MixerRecipe> context, IMultiblockLevel level) {
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level.getRawLevel());
        if (levelData.recipe() == null) {
            this.clearProcess = true;
            return;
        }
        super.doProcessTick(context, level);
        int timerStep = Math.max(levelData.maxTicks() / ((MixerRecipe)levelData.recipe()).fluidAmount, 1);
        for (int processPre = this.processTick; processPre < this.processTick; ++processPre) {
            FluidStack drained;
            double distBetweenExtra;
            if (processPre % timerStep != 0) continue;
            int amount = ((MixerRecipe)levelData.recipe()).fluidAmount / levelData.maxTicks();
            int leftover = ((MixerRecipe)levelData.recipe()).fluidAmount % levelData.maxTicks();
            if (leftover > 0 && Math.floor((double)this.processTick / (distBetweenExtra = (double)levelData.maxTicks() / (double)leftover)) != Math.floor((double)(this.processTick - 1) / distBetweenExtra)) {
                ++amount;
            }
            if ((drained = this.tank.drain(((MixerRecipe)levelData.recipe()).fluidInput.ingredient(), amount, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) continue;
            NonNullList components = NonNullList.withSize((int)this.inputSlots.length, (Object)ItemStack.EMPTY);
            for (int i = 0; i < components.size(); ++i) {
                components.set(i, (Object)context.getInventory().getStackInSlot(this.inputSlots[i]));
            }
            FluidStack output = ((MixerRecipe)levelData.recipe()).getFluidOutput(drained, (NonNullList<ItemStack>)components);
            FluidStack fs = output.copyWithAmount(drained.getAmount());
            this.tank.fillRecipe(fs, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public boolean canProcess(ProcessContext.ProcessContextInMachine<MixerRecipe> context, Level level) {
        MultiblockProcess.LevelDependentData levelData = this.getLevelData(level);
        if (levelData.recipe() == null) {
            return true;
        }
        return context.getEnergy().extractEnergy(levelData.energyPerTick(), true) == levelData.energyPerTick() && !this.tank.drain(((MixerRecipe)levelData.recipe()).fluidInput.ingredient(), 1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }
}

