/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternBlock
extends IEBaseBlock
implements IEBlockInterfaces.IBlockOverlayText {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).lightLevel(b -> (Integer)b.getValue((Property)IEProperties.INT_16)).noOcclusion();
    public static final Property<Direction> FACING = IEProperties.FACING_ALL;
    private static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)1.0, (double)0.75)).put((Object)Direction.UP, (Object)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.NORTH, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.875, (double)1.0)).put((Object)Direction.EAST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.25, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.0, (double)0.75, (double)0.875, (double)0.75)).put((Object)Direction.WEST, (Object)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)1.0, (double)0.875, (double)0.75)).build();

    public LanternBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED, IEProperties.INT_16});
    }

    @Override
    protected BlockState getInitDefaultState() {
        return (BlockState)super.getInitDefaultState().setValue((Property)IEProperties.INT_16, (Comparable)Integer.valueOf(14));
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level level, BlockPos pos, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            level.setBlock(pos, (BlockState)level.getBlockState(pos).cycle((Property)IEProperties.INT_16), 3);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (blockState != null && Utils.isScrewdriver(player.getMainHandItem())) {
            return new Component[]{Component.translatable((String)"chat.immersiveengineering.info.light_level", (Object[])new Object[]{blockState.getValue((Property)IEProperties.INT_16)})};
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
    }
}

