/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.gui.info.MultitankArea;
import blusunrize.immersiveengineering.client.gui.info.TooltipArea;
import blusunrize.immersiveengineering.common.gui.MixerMenu;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class MixerScreen
extends IEContainerScreen<MixerMenu> {
    private static final ResourceLocation TEXTURE = MixerScreen.makeTextureLocation("mixer");
    private static final GuiButtonIE.ButtonTexture OUTPUT_BOTTOM = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("mixer/output_bottom"));
    private static final GuiButtonIE.ButtonTexture OUTPUT_ALL = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("mixer/output_all"));
    private static final ResourceLocation PROGRESS = IEApi.ieLoc("mixer/progress");

    public MixerScreen(MixerMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 167;
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 158, this.topPos + 22, ((MixerMenu)this.menu).energy), (Object)new TooltipArea(new Rect2i(this.leftPos + 106, this.topPos + 61, 30, 16), () -> Component.translatable((String)("gui.immersiveengineering.config.mixer.output" + (((MixerMenu)this.menu).outputAll.get() != false ? "All" : "Single")))), (Object)new MultitankArea(new Rect2i(this.leftPos + 76, this.topPos + 11, 58, 47), 8000, ((MixerMenu)this.menu).tankContents));
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        this.addRenderableWidget((GuiEventListener)new GuiButtonBoolean(this.leftPos + 106, this.topPos + 61, 30, 16, (Component)Component.empty(), ((MixerMenu)this.menu).outputAll::get, OUTPUT_BOTTOM, OUTPUT_ALL, btn -> {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("outputAll", ((MixerMenu)this.menu).outputAll.get() == false);
            this.sendUpdateToServer(tag);
        }));
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        graphics.pose().pushPose();
        for (MixerMenu.SlotProgress slotProgress : ((MixerMenu)this.menu).progress.get()) {
            int slot = slotProgress.slot();
            int h = (int)Math.max(1.0f, slotProgress.progress() * 16.0f);
            graphics.blitSprite(PROGRESS, 3, 16, 0, 16 - h, this.leftPos + 24 + slot % 2 * 21, this.topPos + 7 + slot / 2 * 18 + (16 - h), 2, h);
        }
        graphics.pose().popPose();
    }
}

