/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.utils;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleAVLTreeSet;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class CatenaryTracer {
    private final Connection.CatenaryData catenaryData;
    private final BlockPos offset;
    @VisibleForTesting
    public DoubleSortedSet integerIntersections = null;

    public CatenaryTracer(Connection.CatenaryData catenaryData, BlockPos offset) {
        this.catenaryData = catenaryData;
        this.offset = offset;
    }

    public static double acosh(double arg, CatenaryBranch branch) {
        double factor = branch == CatenaryBranch.NEGATIVE ? -1.0 : 1.0;
        return Math.log(arg + factor * Math.sqrt(arg * arg - 1.0));
    }

    public void calculateIntegerIntersections() {
        this.integerIntersections = new DoubleAVLTreeSet();
        Vec3 across = this.catenaryData.delta();
        Vec3 start = this.catenaryData.vecA();
        Vec3 end = start.add(this.catenaryData.delta());
        across = new Vec3(across.x, 0.0, across.z);
        double lengthHor = across.length();
        this.integerIntersections.add(0.0);
        this.integerIntersections.add(1.0);
        for (int dim = 0; dim <= 2; dim += 2) {
            int startCoord = (int)Math.ceil(Math.min(ApiUtils.getDim(start, dim), ApiUtils.getDim(end, dim)));
            int endCoord = (int)Math.floor(Math.max(ApiUtils.getDim(start, dim), ApiUtils.getDim(end, dim)));
            for (int i = startCoord; i <= endCoord; ++i) {
                double factor = ((double)i - ApiUtils.getDim(start, dim)) / ApiUtils.getDim(across, dim);
                this.integerIntersections.add(factor);
            }
        }
        if (this.catenaryData.isVertical()) {
            min = Math.min(start.y, end.y);
            double max = Math.max(start.y, end.y);
            int y = (int)Math.ceil(min);
            while ((double)y <= Math.floor(max)) {
                double factor = ((double)y - min) / (max - min);
                this.integerIntersections.add(factor);
                ++y;
            }
        } else {
            min = !CatenaryBranch.POSITIVE.exists(this.catenaryData) || !CatenaryBranch.NEGATIVE.exists(this.catenaryData) ? Math.min(start.y, end.y) : this.catenaryData.scale() + this.catenaryData.offsetY() + start.y;
            for (CatenaryBranch branch : CatenaryBranch.values()) {
                if (!branch.exists(this.catenaryData)) continue;
                double max = branch == CatenaryBranch.POSITIVE ? end.y : start.y;
                for (int y = Mth.ceil((double)min); y <= Mth.floor((double)max); ++y) {
                    double yReal = (double)y - start.y;
                    double acosh = CatenaryTracer.acosh((yReal - this.catenaryData.offsetY()) / this.catenaryData.scale(), branch);
                    double posRel = (acosh * this.catenaryData.scale() + this.catenaryData.offsetX()) / lengthHor;
                    Preconditions.checkState((posRel >= -1.0E-5 && posRel <= 1.00001 ? 1 : 0) != 0);
                    if (!(posRel >= 0.0) || !(posRel <= 1.0)) continue;
                    this.integerIntersections.add(posRel);
                }
            }
        }
        double last = 0.0;
        DoubleBidirectionalIterator it = this.integerIntersections.iterator();
        while (it.hasNext()) {
            double current = it.nextDouble();
            if (current > 0.0 && current - last < 1.0E-5) {
                it.remove();
                continue;
            }
            last = current;
        }
    }

    @VisibleForTesting
    public void forEachCloseCoordinate(Vec3 coord, double eps, Consumer<BlockPos> out) {
        for (int x = Mth.floor((double)(coord.x - eps)); x < Mth.ceil((double)(coord.x + eps)); ++x) {
            for (int y = Mth.floor((double)(coord.y - eps)); y < Mth.ceil((double)(coord.y + eps)); ++y) {
                for (int z = Mth.floor((double)(coord.z - eps)); z < Mth.ceil((double)(coord.z + eps)); ++z) {
                    out.accept(new BlockPos(x, y, z));
                }
            }
        }
    }

    public void forEachSegment(Consumer<Segment> out) {
        double epsilonIn = 1.0E-5;
        double epsilonNear = 0.3;
        DoubleBidirectionalIterator it = this.integerIntersections.iterator();
        Vec3 last = this.catenaryData.getPoint(it.nextDouble());
        while (it.hasNext()) {
            Vec3 next = this.catenaryData.getPoint(it.nextDouble());
            HashSet<BlockPos> in = new HashSet<BlockPos>();
            HashSet<BlockPos> near = new HashSet<BlockPos>();
            for (Vec3 pos : new Vec3[]{last, next}) {
                this.forEachCloseCoordinate(pos, 1.0E-5, in::add);
                this.forEachCloseCoordinate(pos, 0.3, near::add);
            }
            near.removeAll(in);
            this.processSegments(in, last, next, true, out);
            this.processSegments(near, last, next, false, out);
            last = next;
        }
    }

    private void processSegments(Set<BlockPos> positions, Vec3 start, Vec3 end, boolean in, Consumer<Segment> out) {
        for (BlockPos p : positions) {
            Vec3 posVec = new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ());
            Vec3 startRel = start.subtract(posVec);
            Vec3 endRel = end.subtract(posVec);
            BlockPos realPos = p.offset((Vec3i)this.offset);
            out.accept(new Segment(startRel, endRel, realPos, in));
        }
    }

    private static enum CatenaryBranch {
        POSITIVE,
        NEGATIVE;


        boolean exists(Connection.CatenaryData data) {
            if (this == NEGATIVE) {
                return data.offsetX() >= 0.0;
            }
            return data.offsetX() <= data.horLength();
        }
    }

    public static class Segment {
        public final Vec3 relativeSegmentStart;
        public final Vec3 relativeSegmentEnd;
        public final BlockPos mainPos;
        public final boolean inBlock;

        public Segment(Vec3 relativeSegmentStart, Vec3 relativeSegmentEnd, BlockPos mainPos, boolean inBlock) {
            this.relativeSegmentStart = relativeSegmentStart;
            this.relativeSegmentEnd = relativeSegmentEnd;
            this.mainPos = mainPos;
            this.inBlock = inBlock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.inBlock == segment.inBlock && this.relativeSegmentStart.equals((Object)segment.relativeSegmentStart) && this.relativeSegmentEnd.equals((Object)segment.relativeSegmentEnd) && this.mainPos.equals((Object)segment.mainPos);
        }

        public int hashCode() {
            return Objects.hash(this.relativeSegmentStart, this.relativeSegmentEnd, this.mainPos, this.inBlock);
        }
    }
}

