/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.events_on_server;

import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.itemstack.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.selectedslot.SelectedSlotCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.sendhandshake.SendHandshakeCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="weaponmaster_ydm", bus=EventBusSubscriber.Bus.GAME)
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        ((IPlayerData)event.getEntity()).setPlayerData(((IPlayerData)event.getOriginal()).getPlayerData());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = event.getEntity();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().level().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = event.getEntity();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        if (!event.getEntity().level().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Player target = (Player)event.getTarget();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            Networking.sendToClient(new SendHandshakeCPacket(player.getStringUUID()), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        PlayerData data;
        Player player;
        if (!event.getEntity().level().isClientSide() && (player = event.getEntity()) != null && (data = ((IPlayerData)player).getPlayerData()) != null && player.getInventory() != null) {
            if (player.getInventory().selected != data.selectedSlot) {
                data.selectedSlot = player.getInventory().selected;
                for (Object sp : player.level().players()) {
                    if (!(sp.distanceToSqr((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new SelectedSlotCPacket(player.getInventory().selected, player.getStringUUID()), (ServerPlayer)sp);
                }
            }
            for (int i = 0; i < 9; ++i) {
                if (player.getInventory().getItem(i) == null || ItemStack.isSameItemSameComponents((ItemStack)player.getInventory().getItem(i), (ItemStack)data.inventory[i])) continue;
                data.inventory[i] = player.getInventory().getItem(i).copy();
                for (Player sp : player.level().players()) {
                    if (!(sp.distanceToSqr((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(Item.getId((Item)data.inventory[i].getItem()), i, player.getStringUUID()), (ServerPlayer)sp);
                }
            }
            if (player.getOffhandItem() != null && !ItemStack.isSameItemSameComponents((ItemStack)player.getOffhandItem(), (ItemStack)data.inventory[9])) {
                data.inventory[9] = player.getOffhandItem().copy();
                for (Object sp : player.level().players()) {
                    if (!(sp.distanceToSqr((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(Item.getId((Item)data.inventory[9].getItem()), 9, player.getStringUUID()), (ServerPlayer)sp);
                }
            }
            boolean hasProjectileWeaponItem = false;
            for (int j = 0; j < 9; ++j) {
                if (data.inventory[j] == null || !(data.inventory[j].getItem() instanceof ProjectileWeaponItem)) continue;
                hasProjectileWeaponItem = true;
                ItemStack ammo = ServerHelper.getProjectile(player, data.inventory[j]);
                if (ItemStack.isSameItemSameComponents((ItemStack)data.inventory[10], (ItemStack)ammo)) continue;
                data.inventory[10] = ammo.copy();
                hasProjectileWeaponItem = true;
                for (Player sp : player.level().players()) {
                    if (!(sp.distanceToSqr((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(Item.getId((Item)ammo.getItem()), 10, player.getStringUUID()), (ServerPlayer)sp);
                }
                break;
            }
            if (!hasProjectileWeaponItem && !ItemStack.isSameItemSameComponents((ItemStack)data.inventory[10], (ItemStack)ItemStack.EMPTY)) {
                data.inventory[10] = ItemStack.EMPTY;
                for (Player sp : player.level().players()) {
                    if (!(sp.distanceToSqr((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(Item.getId((Item)ItemStack.EMPTY.getItem()), 10, player.getStringUUID()), (ServerPlayer)sp);
                }
            }
        }
    }
}

