/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.data.client;

import com.dolthhaven.easeldoesit.common.block.EaselBlock;
import com.dolthhaven.easeldoesit.common.block.VillagerStatueBlock;
import com.dolthhaven.easeldoesit.core.EaselDoesIt;
import com.dolthhaven.easeldoesit.core.registry.EaselModBlocks;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

public class EaselModBlockStates
extends BlueprintBlockStateProvider {
    private static final String ITEM_GENERATED = "item/generated";

    public EaselModBlockStates(GatherDataEvent e) {
        super(e.getGenerator().getPackOutput(), "easel_does_it", e.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        this.easel(EaselModBlocks.EASEL);
    }

    private void doubleBlock(DeferredBlock<? extends Block> doubleBlock) {
        ModelFile.ExistingModelFile topModel = new ModelFile.ExistingModelFile(EaselDoesIt.rl("block/" + this.getName((Supplier<? extends ItemLike>)doubleBlock) + "_top"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile bottomModel = new ModelFile.ExistingModelFile(EaselDoesIt.rl("block/" + this.getName((Supplier<? extends ItemLike>)doubleBlock) + "_bottom"), this.models().existingFileHelper);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)doubleBlock.get());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int rotation = (int)(direction.toYRot() + 180.0f) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)topModel).rotationY(rotation).addModel()).condition(VillagerStatueBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.UPPER}).condition((Property)VillagerStatueBlock.FACING, (Comparable[])new Direction[]{direction});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottomModel).rotationY(rotation).addModel()).condition(VillagerStatueBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER}).condition((Property)VillagerStatueBlock.FACING, (Comparable[])new Direction[]{direction});
        }
    }

    private void easel(DeferredBlock<? extends Block> easel) {
        ModelFile.ExistingModelFile model = new ModelFile.ExistingModelFile(EaselDoesIt.rl("block/" + this.getName((Supplier<? extends ItemLike>)easel)), this.models().existingFileHelper);
        ModelFile.ExistingModelFile paintingModel = new ModelFile.ExistingModelFile(EaselDoesIt.rl("block/" + this.getName((Supplier<? extends ItemLike>)easel) + "_painting"), this.models().existingFileHelper);
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)easel.get());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int rotation = (int)(direction.toYRot() + 180.0f) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.FACING, (Comparable[])new Direction[]{direction}).condition((Property)EaselBlock.HAS_PAINTING, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)paintingModel).rotationY(rotation).addModel()).condition((Property)HorizontalDirectionalBlock.FACING, (Comparable[])new Direction[]{direction}).condition((Property)EaselBlock.HAS_PAINTING, (Comparable[])new Boolean[]{true});
        }
        this.blockItem((Block)easel.get());
    }

    private ConfiguredModel existingModel(String nameSpace) {
        return new ConfiguredModel((ModelFile)new ModelFile.ExistingModelFile(EaselDoesIt.rl(nameSpace), this.models().existingFileHelper));
    }

    private void variantHorizontalDirectionalModel(DeferredBlock<? extends Block> mgBlock, ModelFile model) {
        this.getVariantBuilder((Block)mgBlock.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build());
    }

    private String getName(Supplier<? extends ItemLike> object) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)object.get().asItem())).getPath();
    }
}

