/*
 * Decompiled with CFR 0.152.
 */
package com.dolthhaven.easeldoesit.common.block;

import com.dolthhaven.easeldoesit.common.block.entity.EaselBlockEntity;
import com.dolthhaven.easeldoesit.common.inventory.EaselMenu;
import com.dolthhaven.easeldoesit.other.util.MathUtil;
import com.dolthhaven.easeldoesit.other.util.PaintingUtil;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EaselBlock
extends BaseEntityBlock {
    public static final Component CONTAINER_TITLE = Component.translatable((String)"container.easel_does_it.easel");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HAS_PAINTING = BooleanProperty.create((String)"painting");
    private static final VoxelShape SHAPE_NORTH = Shapes.joinUnoptimized((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)2.0, (double)2.0, (double)15.0, (double)15.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH = Shapes.joinUnoptimized((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)15.0, (double)14.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST = Shapes.joinUnoptimized((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST = Shapes.joinUnoptimized((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.OR);

    public EaselBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return EaselBlock.simpleCodec(EaselBlock::new);
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new EaselMenu(id, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState superState = super.getStateForPlacement(context);
        if (superState == null) {
            return null;
        }
        return (BlockState)((BlockState)superState.setValue((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{FACING}).add(new Property[]{HAS_PAINTING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (EaselBlock.tryPlacePainting(player, level, pos, state, stack)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (EaselBlock.tryTakePainting(player, hand, level, pos)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_STONECUTTER);
        return InteractionResult.CONSUME;
    }

    public static boolean tryTakePainting(Player player, InteractionHand hand, Level level, BlockPos pos) {
        EaselBlockEntity easel;
        BlockEntity entity;
        if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty() && (entity = level.getBlockEntity(pos)) instanceof EaselBlockEntity && !(easel = (EaselBlockEntity)entity).isEmpty()) {
            ItemStack paintingStack = easel.clearContent();
            if (!player.getInventory().add(paintingStack)) {
                player.drop(paintingStack, false);
            }
            level.playSound(null, pos, SoundEvents.PAINTING_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static boolean tryPlacePainting(Player player, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        if (!((Boolean)state.getValue((Property)HAS_PAINTING)).booleanValue() && stack.is(Items.PAINTING) && player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                EaselBlock.placePainting(player, level, pos, state, stack);
            }
            return true;
        }
        return false;
    }

    private static void placePainting(Player player, Level level, BlockPos pos, BlockState state, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EaselBlockEntity) {
            EaselBlockEntity easel = (EaselBlockEntity)blockEntity;
            easel.setPainting(stack.copyWithCount(1));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.PAINTING_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            EaselBlock.togglePainting((Entity)player, pos, level, state, true);
        }
    }

    public static void togglePainting(Entity entity, BlockPos pos, Level level, BlockState state, boolean painting) {
        BlockState newState = (BlockState)state.setValue((Property)HAS_PAINTING, (Comparable)Boolean.valueOf(painting));
        level.setBlock(pos, newState, 1);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state));
    }

    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide) {
            this.popPainting(state, level, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void popPainting(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof EaselBlockEntity) {
            EaselBlockEntity easelEntity = (EaselBlockEntity)blockentity;
            Direction direction = (Direction)state.getValue((Property)FACING);
            ItemStack itemstack = easelEntity.getPainting().copy();
            float f = 0.25f * (float)direction.getStepX();
            float f1 = 0.25f * (float)direction.getStepZ();
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)f, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + (double)f1, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            easelEntity.clearContent();
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EaselBlockEntity) {
            EaselBlockEntity easel = (EaselBlockEntity)blockEntity;
            ItemStack stack = easel.getPainting();
            if (stack.isEmpty()) {
                return 0;
            }
            return PaintingUtil.readStack(stack, (HolderLookup.Provider)level.registryAccess()).map(p -> Math.min(15, MathUtil.base4Minus5(((PaintingVariant)p.value()).width(), ((PaintingVariant)p.value()).height()))).orElse(15);
        }
        return 0;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EaselBlockEntity(pos, state);
    }
}

