/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.block.WindChimeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class WindChimeTyableBlock
extends WindChimeBlock {
    public WindChimeTyableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, HALF, ChimesStates.SILENCED, WATERLOGGED});
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((DoubleBlockHalf)stateIn.getValue((Property)HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            if (worldIn.getBlockState(currentPos.below()).getBlock() != this) {
                if (!this.canSurvive(facingState, (LevelReader)worldIn, currentPos)) {
                    return Blocks.AIR.defaultBlockState();
                }
            } else {
                stateIn = (BlockState)worldIn.getBlockState(currentPos).setValue((Property)ChimesStates.SILENCED, (Comparable)((Boolean)worldIn.getBlockState(currentPos.below()).getValue((Property)ChimesStates.SILENCED)));
            }
        } else {
            if (worldIn.getBlockState(currentPos.above()).getBlock() != this) {
                return Blocks.AIR.defaultBlockState();
            }
            stateIn = (BlockState)worldIn.getBlockState(currentPos).setValue((Property)ChimesStates.SILENCED, (Comparable)((Boolean)worldIn.getBlockState(currentPos.above()).getValue((Property)ChimesStates.SILENCED)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        if (pos.getY() < context.getLevel().getMaxBuildHeight() && context.getLevel().getBlockState(pos.below()).canBeReplaced(context)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(pos).is((Fluid)Fluids.WATER)));
        }
        return null;
    }

    public BlockState changeState(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.cycle((Property)ChimesStates.SILENCED);
        world.setBlock(pos, state, 3);
        return state;
    }

    @Override
    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!((Boolean)state.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
            this.setChiming(state, worldIn, hit.getBlockPos());
        } else {
            this.playTieSound(worldIn, hit.getBlockPos());
        }
    }

    @Override
    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!((Boolean)state.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
            this.playChimeSound(level, pos);
        } else {
            this.playTieSound(level, pos);
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState blockState, Level worldIn, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (!(player.getMainHandItem().getItem() instanceof AxeItem)) {
            if (!player.isSecondaryUseActive() && !((Boolean)blockState.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
                this.setChiming(blockState, worldIn, pos);
            }
            if (((Boolean)blockState.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
                this.playTieSound(worldIn, pos);
                this.changeState(blockState, worldIn, pos);
                worldIn.playSound(null, pos, SoundEvents.LEASH_KNOT_BREAK, SoundSource.BLOCKS, 0.7f, 0.85f);
            }
            if (player.isSecondaryUseActive() && !((Boolean)blockState.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
                this.playTieSound(worldIn, pos);
                this.changeState(blockState, worldIn, pos);
                worldIn.playSound(null, pos, SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 0.7f, 0.85f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

