/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.exclusive_weapons.neoforge.event.providers;

import com.cerbon.exclusive_weapons.item.EWItems;
import com.cerbon.exclusive_weapons.registry.RegistryEntry;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class EWItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public EWItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "exclusive_weapons", existingFileHelper);
    }

    protected void registerModels() {
        EWItems.ITEMS.getEntries().forEach(item -> {
            if (item.get() instanceof ArmorItem) {
                this.trimmedArmorItem((RegistryEntry<Item>)item);
            } else {
                this.handheldItem((Item)item.get());
            }
        });
    }

    private void trimmedArmorItem(RegistryEntry<Item> itemRegistry) {
        String MOD_ID = "exclusive_weapons";
        Item item = itemRegistry.get();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistry.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"exclusive_weapons", (String)("item/" + itemRegistry.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

