/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.spawner;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.spawner.IGoblinData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class GoblinTraderSpawner
extends SavedData {
    private static final Map<EntityType<?>, SpawnData> SPAWN_DATA = new HashMap();
    private static final int SAFE_POSITION_ATTEMPTS = 50;
    private static final int MIN_SPAWN_DISTANCE = 5;
    private static final int GROUND_SEARCH_DISTANCE = 5;
    private static final int SAVE_INTERVAL = 200;
    private final MinecraftServer server;
    private final ServerLevel level;
    private final EntityType<? extends AbstractGoblinEntity> type;
    private final IGoblinData data;
    private int runDelay;
    private int spawnChance;

    public GoblinTraderSpawner(ServerLevel level, EntityType<? extends AbstractGoblinEntity> type, IGoblinData data) {
        this.server = level.getServer();
        this.level = level;
        this.type = type;
        this.data = data;
        this.runDelay = data.getSpawnDelay();
        this.spawnChance = data.getSpawnChance();
    }

    public void serverTick() {
        if (!this.level.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return;
        }
        --this.runDelay;
        if (this.runDelay % 200 == 0) {
            this.setDirty();
        }
        if (this.runDelay > 0) {
            return;
        }
        this.runDelay = this.data.getSpawnInterval();
        if (!this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return;
        }
        double randomChance = this.level.getRandom().nextDouble();
        if ((double)this.spawnChance / 100.0 < randomChance) {
            this.spawnChance = Math.min(this.spawnChance + this.data.getSpawnChance(), 100);
            this.setDirty();
            return;
        }
        if (this.spawnGoblin()) {
            this.runDelay = this.data.getSpawnDelay();
            this.spawnChance = this.data.getSpawnChance();
            this.setDirty();
        }
    }

    private boolean spawnGoblin() {
        ServerPlayer player = this.level.getRandomPlayer();
        if (player == null) {
            return false;
        }
        BlockPos pos = this.createSpawnPosition(player.blockPosition(), 16);
        if (pos == null) {
            return false;
        }
        Holder biome = this.level.getBiome(pos);
        if (biome.is(Biomes.THE_VOID) || biome.is(Biomes.DEEP_DARK)) {
            return false;
        }
        if (pos.getY() < this.data.getMinSpawnYLevel() || pos.getY() >= this.data.getMaxSpawnYLevel()) {
            return false;
        }
        AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.type.spawn(this.level, pos, MobSpawnType.EVENT);
        if (goblin == null) {
            return false;
        }
        this.runDelay = this.data.getSpawnDelay();
        goblin.setDespawnDelay(this.data.getDespawnDelay());
        goblin.restrictTo(pos, 16);
        this.setDirty();
        return true;
    }

    @Nullable
    private BlockPos createSpawnPosition(BlockPos center, int range) {
        for (int i = 0; i < 50; ++i) {
            int posZ;
            int posY;
            int posX = center.getX() + this.createRandomSpawnableDistance(range);
            BlockPos pos = this.findGround(new BlockPos(posX, posY = center.getY() + this.createRandomSpawnableDistance(range), posZ = center.getZ() + this.createRandomSpawnableDistance(range)));
            if (pos == null || pos.closerThan((Vec3i)center, 5.0) || !SpawnPlacements.isSpawnPositionOk(this.type, (LevelReader)this.level, (BlockPos)pos)) continue;
            return pos;
        }
        return null;
    }

    private int createRandomSpawnableDistance(int maxSpawnDistance) {
        RandomSource random = this.level.getRandom();
        int direction = random.nextInt(2) == 0 ? 1 : -1;
        int spawnableRange = Math.max(maxSpawnDistance - 5, 0);
        return (5 + random.nextIntBetweenInclusive(0, spawnableRange)) * direction;
    }

    @Nullable
    private BlockPos findGround(BlockPos pos) {
        int i;
        boolean colliding = this.canCollide(pos);
        BlockPos testPos = pos.below();
        for (i = 0; i < 5 && Level.isInSpawnableBounds((BlockPos)testPos); ++i) {
            if (!this.canCollide(testPos)) {
                colliding = false;
                testPos = testPos.below();
                continue;
            }
            if (colliding) continue;
            return testPos.above();
        }
        colliding = this.canCollide(pos);
        testPos = pos.above();
        for (i = 0; i < 5 && Level.isInSpawnableBounds((BlockPos)testPos); ++i) {
            if (this.canCollide(testPos)) {
                colliding = true;
                testPos = testPos.above();
                continue;
            }
            if (!colliding) continue;
            return testPos;
        }
        return null;
    }

    private boolean canCollide(BlockPos pos) {
        return !this.level.getBlockState(pos).getCollisionShape((BlockGetter)this.level, pos).isEmpty();
    }

    public GoblinTraderSpawner load(CompoundTag tag) {
        if (tag.contains("RunDelay", 3)) {
            this.runDelay = tag.getInt("RunDelay");
        }
        if (tag.contains("SpawnChance", 3)) {
            this.spawnChance = tag.getInt("SpawnChance");
        }
        return this;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("RunDelay", this.runDelay);
        tag.putInt("SpawnChance", this.spawnChance);
        return tag;
    }

    public static Optional<GoblinTraderSpawner> get(MinecraftServer server, EntityType<? extends AbstractGoblinEntity> type) {
        ServerLevel level;
        SpawnData data = SPAWN_DATA.get(type);
        if (data != null && (level = server.getLevel(data.levelKey())) != null) {
            String storageKey = BuiltInRegistries.ENTITY_TYPE.getKey(type).toString().replaceAll("[^a-z]", "_") + "_spawner";
            return Optional.of((GoblinTraderSpawner)level.getDataStorage().computeIfAbsent(GoblinTraderSpawner.dataFactory(level, type, data), storageKey));
        }
        return Optional.empty();
    }

    private static SavedData.Factory<GoblinTraderSpawner> dataFactory(ServerLevel level, EntityType<? extends AbstractGoblinEntity> type, SpawnData data) {
        return new SavedData.Factory(() -> GoblinTraderSpawner.createSpawner(level, type, data), (tag, provider) -> GoblinTraderSpawner.createSpawner(level, type, data).load((CompoundTag)tag), DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    }

    private static GoblinTraderSpawner createSpawner(ServerLevel level, EntityType<? extends AbstractGoblinEntity> type, SpawnData data) {
        return new GoblinTraderSpawner(level, type, data.goblinData.get());
    }

    public static void register(EntityType<? extends AbstractGoblinEntity> type, ResourceKey<Level> levelKey, Supplier<IGoblinData> goblinData) {
        SPAWN_DATA.putIfAbsent(type, new SpawnData(levelKey, goblinData));
    }

    private record SpawnData(ResourceKey<Level> levelKey, Supplier<IGoblinData> goblinData) {
    }
}

