/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity.ai.goal;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class TradeWithPlayerGoal
extends Goal {
    private AbstractGoblinEntity entity;

    public TradeWithPlayerGoal(AbstractGoblinEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.entity.isAlive()) {
            return false;
        }
        if (this.entity.isInWater()) {
            return false;
        }
        if (!this.entity.onGround()) {
            return false;
        }
        if (this.entity.hurtMarked) {
            return false;
        }
        Player player = this.entity.getTradingPlayer();
        if (player == null) {
            return false;
        }
        if (this.entity.distanceToSqr((Entity)player) > 16.0) {
            return false;
        }
        return player.containerMenu != null;
    }

    public void start() {
        this.entity.getNavigation().stop();
    }

    public void stop() {
        this.entity.setTradingPlayer(null);
    }
}

