/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.mixin;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class PlayerMovementNoUnloaded {
    @Shadow
    public ServerPlayer player;
    @Shadow
    private double firstGoodX;
    @Shadow
    private double firstGoodZ;

    @Shadow
    private static double clampHorizontal(double p_143610_) {
        return 0.0;
    }

    @Inject(method={"handleMovePlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void onMove(ServerboundMovePlayerPacket packet, CallbackInfo ci) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).preventWalkUnloaded) {
            return;
        }
        double clampedPacketX = PlayerMovementNoUnloaded.clampHorizontal(packet.getX(this.player.getX()));
        double clampedPacketZ = PlayerMovementNoUnloaded.clampHorizontal(packet.getZ(this.player.getZ()));
        double xDiff = Math.max(-16.0, Math.min(16.0, (clampedPacketX - this.firstGoodX) * 4.0));
        double zDiff = Math.max(-16.0, Math.min(16.0, (clampedPacketZ - this.firstGoodZ) * 4.0));
        int projectedChunkX = Mth.floor((double)(this.player.getX() + xDiff)) >> 4;
        int projectedChunkZ = Mth.floor((double)(this.player.getZ() + zDiff)) >> 4;
        if (!(projectedChunkX == this.player.chunkPosition().x && projectedChunkZ == this.player.chunkPosition().z || this.player.level().hasChunk(projectedChunkX, projectedChunkZ))) {
            if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
                BetterChunkLoading.LOGGER.warn("Preventing player movement into unloaded chunk for:" + String.valueOf(this.player) + "! xDiff:" + xDiff + " zdiff:" + zDiff);
            }
            ci.cancel();
        }
    }
}

