/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.event;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.chunk.IPlayerDataPlayer;
import com.betterchunkloading.chunk.PlayerChunkData;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.ITickingTask;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class EventHandler {
    private static ArrayDeque<ChunkInfo> delayedLoading = new ArrayDeque();
    private static Map<ChunkPos, ChunkInfo> delayedLoadingMap = new HashMap<ChunkPos, ChunkInfo>();
    private static List<ChunkInfo> toadd = new ArrayList<ChunkInfo>();
    private static int tickTimer = 0;
    public static int MSTP = 0;
    public static volatile ChunkPos loadingChunk = null;
    private static int loadedChunks = 0;
    private static int unloadedChunks = 0;
    static Map<ChunkPos, Integer> recentlyLoadedTimes = new HashMap<ChunkPos, Integer>();
    static Map<ChunkPos, Integer> recentlyUnLoadedTimes = new HashMap<ChunkPos, Integer>();
    static Map<ChunkPos, LevelChunk> loadedChunksMap = new HashMap<ChunkPos, LevelChunk>();
    private static Map<ResourceKey<Level>, List<ITickingTask>> taskMap = new HashMap<ResourceKey<Level>, List<ITickingTask>>();

    public static void addChunkToQueue(ChunkInfo info) {
        if (info.level.getServer() != null && !info.level.getServer().isSameThread()) {
            info.level.getServer().submit(() -> EventHandler.addChunkToQueue(info));
        } else {
            if (delayedLoadingMap.containsKey(info.pos)) {
                if (BetterChunkLoading.IN_DEV) {
                    BetterChunkLoading.LOGGER.error("processing chunk twice!", (Throwable)new Exception());
                }
                return;
            }
            toadd.add(info);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (ChunkInfo info : toadd) {
            delayedLoadingMap.put(info.pos, info);
            delayedLoading.offer(info);
        }
        if (++tickTimer >= 40) {
            CommonConfiguration.convertWaterSource = event.getServer().getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
            CommonConfiguration.convertLavaSource = event.getServer().getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION);
            tickTimer = 0;
            MSTP = (int)((double)EventHandler.average(event.getServer().getTickTimesNanos()) * 1.0E-6);
        }
        if (!toadd.isEmpty()) {
            toadd = new ArrayList<ChunkInfo>();
        }
        long serverTime = event.getServer().getTickCount();
        int amount = 0;
        Iterator<ChunkInfo> iterator = delayedLoading.iterator();
        while (iterator.hasNext()) {
            ChunkInfo chunkInfo = iterator.next();
            if (serverTime - chunkInfo.originalTime > 20L && chunkInfo.level.hasChunk(chunkInfo.pos.x, chunkInfo.pos.z) && chunkInfo.level.hasChunk(chunkInfo.pos.x + 1, chunkInfo.pos.z + 1) && chunkInfo.level.hasChunk(chunkInfo.pos.x + 1, chunkInfo.pos.z) && chunkInfo.level.hasChunk(chunkInfo.pos.x + 1, chunkInfo.pos.z - 1) && chunkInfo.level.hasChunk(chunkInfo.pos.x, chunkInfo.pos.z + 1) && chunkInfo.level.hasChunk(chunkInfo.pos.x, chunkInfo.pos.z - 1) && chunkInfo.level.hasChunk(chunkInfo.pos.x - 1, chunkInfo.pos.z + 1) && chunkInfo.level.hasChunk(chunkInfo.pos.x - 1, chunkInfo.pos.z) && chunkInfo.level.hasChunk(chunkInfo.pos.x - 1, chunkInfo.pos.z - 1)) {
                EventHandler.applyToChunk(chunkInfo);
                delayedLoadingMap.remove(chunkInfo.pos);
                iterator.remove();
                if (++amount <= 10 && chunkInfo.level.getServer().haveTime()) continue;
                return;
            }
            if (serverTime - chunkInfo.originalTime > 1200L && !chunkInfo.addedTicket) {
                chunkInfo.addedTicket = true;
                chunkInfo.originalTime = serverTime - 1200L;
                ((ServerLevel)chunkInfo.level).getChunkSource().distanceManager.addTicket(BetterChunkLoading.TICKET_POST_PROCESS, chunkInfo.pos, PlayerChunkData.getTicketLevelForArea(2), (Object)chunkInfo.pos);
                continue;
            }
            if (serverTime - chunkInfo.originalTime <= 1800L) break;
            if (BetterChunkLoading.IN_DEV && ((ServerLevel)chunkInfo.level).getChunkSource().distanceManager.tickets.get(chunkInfo.pos.toLong()) == null) {
                BetterChunkLoading.LOGGER.warn("Missing ticket!!!");
                ((ServerLevel)chunkInfo.level).getChunkSource().distanceManager.runAllUpdates(((ServerLevel)chunkInfo.level).getChunkSource().chunkMap);
                if (((ServerLevel)chunkInfo.level).getChunkSource().distanceManager.tickets.get(chunkInfo.pos.toLong()) == null) {
                    BetterChunkLoading.LOGGER.warn("Really! Missing ticket!!! time since ticket:" + ((long)chunkInfo.level.getServer().getTickCount() - chunkInfo.originalTime));
                }
            }
            EventHandler.applyToChunk(chunkInfo);
            iterator.remove();
            delayedLoadingMap.remove(chunkInfo.pos);
            return;
        }
    }

    private static void applyToChunk(ChunkInfo chunkInfo) {
        LevelChunk chunk = chunkInfo.level.getChunk(chunkInfo.pos.x, chunkInfo.pos.z);
        for (int i = 0; i < chunkInfo.data.length; ++i) {
            if (chunkInfo.data[i] == null) continue;
            for (Short oshort : chunkInfo.data[i]) {
                BlockPos blockpos = ProtoChunk.unpackOffsetCoordinates((short)oshort, (int)chunk.getSectionYFromSectionIndex(i), (ChunkPos)chunkInfo.pos);
                BlockState blockstate = chunk.getBlockState(blockpos);
                FluidState fluidstate = blockstate.getFluidState();
                if (!fluidstate.isEmpty()) {
                    fluidstate.tick(chunkInfo.level, blockpos);
                }
                if (blockstate.getBlock() instanceof LiquidBlock) continue;
                BlockState blockstate1 = Block.updateFromNeighbourShapes((BlockState)blockstate, (LevelAccessor)chunkInfo.level, (BlockPos)blockpos);
                chunkInfo.level.setBlock(blockpos, blockstate1, 20);
                ClientboundBlockUpdatePacket packet = new ClientboundBlockUpdatePacket(blockpos, chunk.getBlockState(blockpos));
                for (ServerPlayer player : ((ServerChunkCache)chunkInfo.level.getChunkSource()).chunkMap.getPlayers(chunkInfo.pos, false)) {
                    player.connection.send((Packet)packet);
                }
            }
        }
        ((ServerChunkCache)chunkInfo.level.getChunkSource()).distanceManager.removeTicket(BetterChunkLoading.TICKET_POST_PROCESS, chunkInfo.pos, ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - 1, (Object)chunkInfo.pos);
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        CommonConfiguration.convertWaterSource = event.getServer().getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
        CommonConfiguration.convertLavaSource = event.getServer().getGameRules().getBoolean(GameRules.RULE_LAVA_SOURCE_CONVERSION);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        if (event.getEntity().tickCount % 3 == 0 && (player = event.getEntity()) instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            if (event.getEntity().getClass() == ServerPlayer.class) {
                dataPlayer.betterchunkloading$getPlayerChunkData().onChunkChanged((ServerPlayer)event.getEntity(), null);
            }
        }
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        if (event.getEntity().level().getGameTime() % 200L == 0L) {
            BetterChunkLoading.LOGGER.warn("Loaded chunks: " + loadedChunks + " unloaded: " + unloadedChunks + " total:" + loadedChunksMap.size());
            loadedChunks = 0;
            unloadedChunks = 0;
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide && (player = event.getEntity()) instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            if (event.getEntity() instanceof ServerPlayer) {
                dataPlayer.betterchunkloading$getPlayerChunkData().onLogout((ServerPlayer)event.getEntity());
            }
        }
        recentlyLoadedTimes = new HashMap<ChunkPos, Integer>();
        recentlyUnLoadedTimes = new HashMap<ChunkPos, Integer>();
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        Integer prev;
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        loadedChunksMap.put(event.getChunk().getPos(), (LevelChunk)event.getChunk());
        ++loadedChunks;
        if (loadingChunk != null) {
            BetterChunkLoading.LOGGER.warn("Loading chunk while stalled:" + String.valueOf(event.getChunk().getPos()));
            loadingChunk = null;
        }
        boolean sr = false;
        sr |= event.getLevel().hasChunk(event.getChunk().getPos().x + 1, event.getChunk().getPos().z);
        sr |= event.getLevel().hasChunk(event.getChunk().getPos().x, event.getChunk().getPos().z + 1);
        sr |= event.getLevel().hasChunk(event.getChunk().getPos().x - 1, event.getChunk().getPos().z);
        if (!(sr |= event.getLevel().hasChunk(event.getChunk().getPos().x, event.getChunk().getPos().z - 1))) {
            BetterChunkLoading.LOGGER.warn("no surrounding chunk!");
        }
        if ((prev = recentlyLoadedTimes.put(event.getChunk().getPos(), event.getLevel().getServer().getTickCount())) != null && event.getLevel().getServer().getTickCount() - prev < 100) {
            BetterChunkLoading.LOGGER.warn("Loaded shortly again:" + String.valueOf(event.getChunk().getPos()));
        }
        if (recentlyUnLoadedTimes.containsKey(event.getChunk().getPos()) && event.getLevel().getServer().getTickCount() - recentlyUnLoadedTimes.get(event.getChunk().getPos()) < 100) {
            BetterChunkLoading.LOGGER.warn("Loaded shortly after unload:" + String.valueOf(event.getChunk().getPos()));
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        loadedChunksMap.remove(event.getChunk().getPos());
        ++unloadedChunks;
        recentlyUnLoadedTimes.put(event.getChunk().getPos(), event.getLevel().getServer().getTickCount());
        if (recentlyLoadedTimes.containsKey(event.getChunk().getPos()) && event.getLevel().getServer().getTickCount() - recentlyLoadedTimes.get(event.getChunk().getPos()) < 100) {
            BetterChunkLoading.LOGGER.warn("UnLoaded shortly after load:" + String.valueOf(event.getChunk().getPos()));
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        List<ITickingTask> tasks;
        if (!event.getLevel().isClientSide() && (tasks = taskMap.get(event.getLevel().dimension())) != null && !tasks.isEmpty()) {
            Iterator<ITickingTask> iterator = tasks.iterator();
            while (iterator.hasNext()) {
                ITickingTask task = iterator.next();
                if (!task.tick()) continue;
                iterator.remove();
            }
        }
    }

    public static void addTickingTask(ResourceKey<Level> levelID, ITickingTask task) {
        List<ITickingTask> taskList = taskMap.get(levelID);
        if (taskList == null) {
            taskList = new ArrayList<ITickingTask>();
        }
        taskList.add(task);
        taskMap.put(levelID, taskList);
    }

    public static void removeTickingTask(ResourceKey<Level> levelID, Predicate<ITickingTask> matcher) {
        List<ITickingTask> taskList = taskMap.get(levelID);
        if (taskList == null) {
            return;
        }
        taskList.removeIf(matcher);
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    public static class ChunkInfo {
        private long originalTime;
        private final ChunkPos pos;
        private final Level level;
        private final ShortList[] data;
        public boolean addedTicket = false;

        public ChunkInfo(long originalTime, ChunkPos pos, Level level, ShortList[] data) {
            this.originalTime = originalTime;
            this.pos = pos;
            this.level = level;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkInfo chunkInfo = (ChunkInfo)o;
            return Objects.equals(this.pos, chunkInfo.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

