/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.client.gui.WindowExtendedBuildTool;
import com.ldtteam.structurize.items.AbstractItemStructurize;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemBuildTool
extends AbstractItemStructurize {
    public ItemBuildTool() {
        super("sceptergold", new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            ItemBuildTool.openBuildToolWindow(context.getClickedPos().relative(context.getClickedFace()), 1, (HolderLookup.Provider)context.getLevel().registryAccess());
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            ItemBuildTool.openBuildToolWindow(null, 1, (HolderLookup.Provider)worldIn.registryAccess());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private static void openBuildToolWindow(BlockPos pos, int groundstyle, HolderLookup.Provider provider) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        new WindowExtendedBuildTool(pos, groundstyle, null, WindowExtendedBuildTool.BLOCK_BLUEPRINT_REQUIREMENT, provider).open();
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (ItemStackUtils.isEmpty(itemStack)) {
            return ItemStack.EMPTY;
        }
        return itemStack.copy();
    }

    public boolean hasCraftingRemainingItem(ItemStack itemStack) {
        return !ItemStackUtils.isEmpty(itemStack);
    }
}

