/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.items.ItemTagTool;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.WorldRenderMacros;
import java.util.List;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class WorldRenderContext
extends WorldRenderMacros {
    static final WorldRenderContext INSTANCE = new WorldRenderContext();

    @Override
    protected void renderWithinContext(RenderLevelStageEvent.Stage stage) {
        RenderLevelStageEvent.Stage when;
        double alpha = (Double)((ClientConfiguration)Structurize.getConfig().getClient()).rendererTransparency.get();
        boolean isAlphaApplied = alpha > 0.0 && alpha < (double)0.99f;
        RenderLevelStageEvent.Stage stage2 = when = isAlphaApplied ? RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS : RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES;
        if (stage == when) {
            this.renderBlueprints();
        }
        if (stage == WorldRenderMacros.STAGE_FOR_LINES) {
            this.renderBoxes();
            this.renderTagTool();
        }
    }

    private void renderBlueprints() {
        for (BlueprintPreviewData previewData : RenderingCache.getBlueprintsToRender()) {
            Blueprint blueprint = previewData.getBlueprint();
            if (blueprint == null) continue;
            this.mc.getProfiler().push("struct_render");
            this.renderBlueprint(previewData, previewData.getPos());
            this.mc.getProfiler().pop();
        }
    }

    private void renderBoxes() {
        for (BlueprintPreviewData blueprintPreviewData : RenderingCache.getBlueprintsToRender()) {
            Blueprint blueprint = blueprintPreviewData.getBlueprint();
            if (blueprint == null) continue;
            BlockPos anchor = blueprint.getPrimaryBlockOffset();
            this.mc.getProfiler().push("struct_render");
            this.pushPoseCameraToPos(blueprintPreviewData.getPos().subtract((Vec3i)anchor));
            this.renderWhiteLineBox(BlockPos.ZERO, new BlockPos(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1), 0.025f);
            this.renderRedGlintLineBox(anchor, anchor, 0.025f);
            this.popPose();
            this.mc.getProfiler().pop();
        }
        for (BoxPreviewData boxPreviewData : RenderingCache.getBoxesToRender()) {
            BlockPos root = boxPreviewData.pos1();
            this.mc.getProfiler().push("struct_box");
            this.pushPoseCameraToPos(root);
            this.renderWhiteLineBox(BlockPos.ZERO, boxPreviewData.pos2().subtract((Vec3i)root), 0.025f);
            boxPreviewData.anchor().map(pos -> pos.subtract((Vec3i)root)).ifPresent(pos -> this.renderRedGlintLineBox((BlockPos)pos, (BlockPos)pos, 0.025f));
            this.popPose();
            this.mc.getProfiler().pop();
        }
    }

    private void renderTagTool() {
        LocalPlayer player = this.mc.player;
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemTagTool.TagData tags = ItemTagTool.TagData.readFromItemStack(itemStack);
        if (tags.anchorPos().isPresent()) {
            BlockPos tagAnchor = tags.anchorPos().get();
            BlockEntity te = player.level().getBlockEntity(tagAnchor);
            this.mc.getProfiler().push("struct_tags");
            this.pushPoseCameraToPos(tagAnchor);
            if (te instanceof IBlueprintDataProviderBE) {
                IBlueprintDataProviderBE blueprintProvider = (IBlueprintDataProviderBE)te;
                Map<BlockPos, List<String>> tagPosList = blueprintProvider.getWorldTagPosMap();
                for (Map.Entry<BlockPos, List<String>> entry : tagPosList.entrySet()) {
                    BlockPos pos = entry.getKey().subtract((Vec3i)tagAnchor);
                    this.renderWhiteLineBox(pos, pos, 0.025f);
                    this.renderDebugText(pos, entry.getKey(), entry.getValue(), true, 3);
                }
            }
            this.renderRedGlintLineBox(BlockPos.ZERO, BlockPos.ZERO, 0.025f);
            this.popPose();
            this.mc.getProfiler().pop();
        }
    }
}

