/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanCommand
extends AbstractCommand {
    public static final String NAME = "scan";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String SCAN_SUCCESS_MESSAGE = "com.structurize.command.scan.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.scan.no.perm";
    public static final String FILE_NAME = "filename";
    public static final String PLAYER_NAME = "player";
    public static final String POS1 = "pos1";
    public static final String POS2 = "pos2";
    public static final String ANCHOR_POS = "anchor_pos";

    private static int execute(CommandSourceStack source, BlockPos from, BlockPos to, Optional<BlockPos> anchorPos, GameProfile profile, String name) throws CommandSyntaxException {
        ServerPlayer player;
        @Nullable ServerLevel world = source.getLevel();
        if (source.getEntity() instanceof Player && !source.getPlayerOrException().isCreative()) {
            source.sendFailure((Component)Component.literal((String)NO_PERMISSION_MESSAGE));
            return 0;
        }
        if (profile != null && world.getServer() != null) {
            player = world.getServer().getPlayerList().getPlayer(profile.getId());
            if (player == null) {
                source.sendFailure((Component)Component.translatable((String)PLAYER_NOT_FOUND, (Object[])new Object[]{profile.getName()}));
                return 0;
            }
        } else if (source.getEntity() instanceof Player) {
            player = source.getPlayerOrException();
        } else {
            source.sendFailure((Component)Component.translatable((String)PLAYER_NOT_FOUND));
            return 0;
        }
        ItemScanTool.saveStructure((Level)world, (Player)player, new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchorPos)), true);
        source.sendFailure((Component)Component.translatable((String)SCAN_SUCCESS_MESSAGE));
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), null, null);
    }

    private static int onExecuteWithAnchor(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.getSpawnablePos(context, (String)ANCHOR_POS);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), null, null);
    }

    private static int onExecuteWithPlayerName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, null);
    }

    private static int onExecuteWithPlayerNameAndFileName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.empty(), profile, name);
    }

    private static int onExecuteWithPlayerNameAndFileNameAndAnchorPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos from = BlockPosArgument.getSpawnablePos(context, (String)POS1);
        BlockPos to = BlockPosArgument.getSpawnablePos(context, (String)POS2);
        BlockPos anchorPos = BlockPosArgument.getSpawnablePos(context, (String)ANCHOR_POS);
        GameProfile profile = GameProfileArgument.getGameProfiles(context, (String)PLAYER_NAME).stream().findFirst().orElse(null);
        String name = StringArgumentType.getString(context, (String)FILE_NAME);
        return ScanCommand.execute((CommandSourceStack)context.getSource(), from, to, Optional.of(anchorPos), profile, name);
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)ScanCommand.newLiteral(NAME).then(ScanCommand.newArgument(POS1, BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ScanCommand.newArgument(POS2, BlockPosArgument.blockPos()).executes(ScanCommand::onExecute)).then(ScanCommand.newArgument(ANCHOR_POS, BlockPosArgument.blockPos()).executes(ScanCommand::onExecuteWithAnchor))).then(((RequiredArgumentBuilder)ScanCommand.newArgument(PLAYER_NAME, GameProfileArgument.gameProfile()).executes(ScanCommand::onExecuteWithPlayerName)).then(((RequiredArgumentBuilder)ScanCommand.newArgument(FILE_NAME, StringArgumentType.string()).executes(ScanCommand::onExecuteWithPlayerNameAndFileName)).then(ScanCommand.newArgument(ANCHOR_POS, BlockPosArgument.blockPos()).executes(ScanCommand::onExecuteWithPlayerNameAndFileNameAndAnchorPos))))));
    }

    @NotNull
    public static String format(@NotNull ScanToolData.Slot slot) {
        String name = slot.name().chars().anyMatch(c -> !StringReader.isAllowedInUnquotedString((char)((char)c))) ? StringTag.quoteAndEscape((String)slot.name()) : slot.name();
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("/%s %s %s %s @p %s", "structurize", NAME, BlockPosUtil.format(slot.box().pos1()), BlockPosUtil.format(slot.box().pos2()), name));
        if (slot.box().anchor().isPresent() && BlockPosUtil.isInbetween(slot.box().anchor().get(), slot.box().pos1(), slot.box().pos2())) {
            builder.append(' ');
            builder.append(BlockPosUtil.format(slot.box().anchor().get()));
        }
        return builder.toString();
    }
}

