/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.portal;

import com.leclowndu93150.custom_nether_portals.CNPBlocks;
import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;

public class HorizontalPortalForcer {
    private static final int FRAME_HEIGHT = 3;
    private static final int FRAME_WIDTH = 4;
    private static final int PORTAL_SEARCH_RADIUS = 16;
    private final ServerLevel level;

    public HorizontalPortalForcer(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockUtil.FoundRectangle> createHorizontalPortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (BlockPos.MutableBlockPos searchPos : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int k = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, searchPos.getX(), searchPos.getZ()));
            if (!worldborder.isWithinBounds((BlockPos)searchPos) || !worldborder.isWithinBounds((BlockPos)searchPos.move(direction, 1))) continue;
            searchPos.move(direction.getOpposite(), 1);
            for (int y = k; y >= this.level.getMinBuildHeight(); --y) {
                searchPos.setY(y);
                if (!this.canPlaceHorizontalPortal((BlockPos)searchPos)) continue;
                int bottomY = y;
                while (y > this.level.getMinBuildHeight() && this.canPlaceHorizontalPortal((BlockPos)searchPos.move(Direction.DOWN))) {
                    --y;
                }
                if (bottomY - y > 3 || bottomY - y < 1) continue;
                searchPos.setY(y + 1);
                if (!this.canHostHorizontalFrame((BlockPos)searchPos, mutablePos, direction)) continue;
                double dist = pos.distSqr((Vec3i)searchPos);
                if (d0 == -1.0 || d0 > dist) {
                    d0 = dist;
                    blockpos = searchPos.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > dist)) continue;
                d1 = dist;
                blockpos1 = searchPos.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int maxY = i - 9;
            int minY = Math.max(this.level.getMinBuildHeight(), 70);
            if (maxY < minY) {
                return Optional.empty();
            }
            blockpos = new BlockPos(pos.getX(), Mth.clamp((int)pos.getY(), (int)minY, (int)maxY), pos.getZ()).immutable();
            blockpos = worldborder.clampToBounds(blockpos);
        }
        Direction perpendicular = direction.getClockWise();
        for (int x = -1; x <= 4; ++x) {
            for (int z = -1; z <= 3; ++z) {
                boolean isFrame = x == -1 || x == 4 || z == -1 || z == 3;
                mutablePos.setWithOffset((Vec3i)blockpos, x * direction.getStepX() + z * perpendicular.getStepX(), 0, x * direction.getStepZ() + z * perpendicular.getStepZ());
                if (isFrame) {
                    this.level.setBlock((BlockPos)mutablePos, Blocks.OBSIDIAN.defaultBlockState(), 3);
                    if (!this.level.getBlockState(mutablePos.below()).isAir()) continue;
                    this.level.setBlock(mutablePos.below(), Blocks.NETHERRACK.defaultBlockState(), 3);
                    continue;
                }
                this.level.setBlock(mutablePos.above(), Blocks.AIR.defaultBlockState(), 3);
            }
        }
        BlockState portalState = (BlockState)CNPBlocks.HORIZONTAL_NETHER_PORTAL.defaultBlockState().setValue(HorizontalNetherPortalBlock.AXIS, (Comparable)axis);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 3; ++z) {
                mutablePos.setWithOffset((Vec3i)blockpos, x * direction.getStepX() + z * perpendicular.getStepX(), 0, x * direction.getStepZ() + z * perpendicular.getStepZ());
                if (!this.level.getBlockState(mutablePos.below()).isAir()) continue;
                this.level.setBlock(mutablePos.below(), Blocks.NETHERRACK.defaultBlockState(), 3);
            }
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 3; ++z) {
                    mutablePos.setWithOffset((Vec3i)blockpos, x * direction.getStepX() + z * perpendicular.getStepX(), 0, x * direction.getStepZ() + z * perpendicular.getStepZ());
                    this.level.setBlock((BlockPos)mutablePos, portalState, 18);
                }
            }
        }
        BlockUtil.FoundRectangle result = new BlockUtil.FoundRectangle(blockpos.immutable(), 4, 3);
        return Optional.of(result);
    }

    private boolean canPlaceHorizontalPortal(BlockPos pos) {
        BlockState state = this.level.getBlockState(pos);
        boolean canPlace = state.isAir() || state.canBeReplaced();
        return canPlace;
    }

    private boolean canHostHorizontalFrame(BlockPos pos, BlockPos.MutableBlockPos mutablePos, Direction direction) {
        Direction perpendicular = direction.getClockWise();
        for (int x = -1; x <= 4; ++x) {
            for (int z = -1; z <= 3; ++z) {
                mutablePos.setWithOffset((Vec3i)pos, x * direction.getStepX() + z * perpendicular.getStepX(), -1, x * direction.getStepZ() + z * perpendicular.getStepZ());
                if (!this.level.getBlockState((BlockPos)mutablePos).isSolid()) {
                    return false;
                }
                mutablePos.move(Direction.UP, 1);
                if (this.canPlaceHorizontalPortal((BlockPos)mutablePos)) continue;
                return false;
            }
        }
        return true;
    }
}

