/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import com.leclowndu93150.custom_nether_portals.portal.HorizontalPortalForcer;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PortalForcer.class})
public class PortalForcerMixin {
    @Shadow
    @Final
    private ServerLevel level;

    @Inject(method={"findClosestPortalPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void findClosestPortalPositionWithCustomPortals(BlockPos pExitPos, boolean pIsNether, WorldBorder pWorldBorder, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        PoiManager poimanager = this.level.getPoiManager();
        int i = pIsNether ? 16 : 128;
        poimanager.ensureLoadedAndValid((LevelReader)this.level, pExitPos, i);
        Stream<BlockPos> var10000 = poimanager.getInSquare(p_230634_ -> p_230634_.is(PoiTypes.NETHER_PORTAL), pExitPos, i, PoiManager.Occupancy.ANY).map(PoiRecord::getPos);
        Objects.requireNonNull(pWorldBorder);
        Optional<BlockPos> result = var10000.filter(arg_0 -> ((WorldBorder)pWorldBorder).isWithinBounds(arg_0)).filter(pos -> {
            BlockState blockState = this.level.getBlockState(pos);
            return blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS) || blockState.getBlock() instanceof HorizontalNetherPortalBlock && blockState.hasProperty(HorizontalNetherPortalBlock.AXIS);
        }).min(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)pExitPos)).thenComparingInt(Vec3i::getY));
        cir.setReturnValue(result);
    }

    @Inject(method={"createPortal"}, at={@At(value="HEAD")}, cancellable=true)
    private void createHorizontalPortal(BlockPos pos, Direction.Axis axis, CallbackInfoReturnable<Optional<BlockUtil.FoundRectangle>> cir) {
        HorizontalPortalForcer horizontalForcer;
        Optional<BlockUtil.FoundRectangle> result;
        if (pos.getY() < 100 && this.level.getRandom().nextFloat() < 0.5f && (result = (horizontalForcer = new HorizontalPortalForcer(this.level)).createHorizontalPortal(pos, axis)).isPresent()) {
            cir.setReturnValue(result);
        }
    }
}

