/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.cursedness.HorizontalPortalShape;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlintAndSteelItem.class})
public class FlintAndSteelItemMixin {
    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleHorizontalPortalCreation(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Optional<HorizontalPortalShape> portalShape;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (!FlintAndSteelItemMixin.inPortalDimension(level)) {
            return;
        }
        if (clickedState.isAir() && (portalShape = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, clickedPos)).isPresent()) {
            level.playSound(player, clickedPos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            if (!level.isClientSide()) {
                portalShape.get().createPortalBlocks();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)serverPlayer, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, clickedPos);
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide()));
            return;
        }
        if (clickedState.is(Blocks.OBSIDIAN) || clickedState.is(Blocks.CRYING_OBSIDIAN)) {
            Direction clickedFace = context.getClickedFace();
            if (clickedFace.getAxis().isHorizontal()) {
                BlockPos firePos = clickedPos.relative(clickedFace);
                Optional<HorizontalPortalShape> portalShape2 = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, firePos);
                if (portalShape2.isPresent()) {
                    level.playSound(player, firePos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    if (!level.isClientSide()) {
                        portalShape2.get().createPortalBlocks();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            context.getItemInHand().hurtAndBreak(1, (LivingEntity)serverPlayer, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                        }
                    }
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, firePos);
                    cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    return;
                }
            } else {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    Optional<HorizontalPortalShape> portalShape3;
                    BlockPos firePos = clickedPos.relative(direction);
                    if (!level.getBlockState(firePos).isAir() || !BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)firePos, (Direction)direction) || !(portalShape3 = HorizontalPortalShape.findEmptyPortalShape((LevelAccessor)level, firePos)).isPresent()) continue;
                    level.playSound(player, firePos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                    if (!level.isClientSide()) {
                        portalShape3.get().createPortalBlocks();
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            context.getItemInHand().hurtAndBreak(1, (LivingEntity)serverPlayer, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                        }
                    }
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, firePos);
                    cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                    return;
                }
            }
        }
    }

    private static boolean inPortalDimension(Level level) {
        return level.dimension() == Level.OVERWORLD || level.dimension() == Level.NETHER;
    }
}

