/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.common.config.ConfigLocalization;
import net.blay09.mods.waystones.InternalMethodsImpl;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.command.ModCommands;
import net.blay09.mods.waystones.component.ModComponents;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.handler.ModEventHandlers;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.network.ModNetworking;
import net.blay09.mods.waystones.permission.ModPermissions;
import net.blay09.mods.waystones.requirement.RequirementRegistry;
import net.blay09.mods.waystones.resources.ForceSpawnInVillagesCondition;
import net.blay09.mods.waystones.stats.ModStats;
import net.blay09.mods.waystones.worldgen.ModWorldGen;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waystones {
    public static final Logger logger = LoggerFactory.getLogger(Waystones.class);
    public static final String MOD_ID = "waystones";

    public static void initialize() {
        ConfigLocalization.enableModernTranslationKeys((String)MOD_ID);
        WaystonesAPI.__internalMethods = new InternalMethodsImpl();
        RequirementRegistry.registerDefaults();
        WaystonesConfig.initialize();
        Balm.getResources().registerResourceCondition(Waystones.id("force_spawn_in_villages"), ForceSpawnInVillagesCondition.CODEC);
        ModStats.initialize();
        ModPermissions.initialize();
        ModEventHandlers.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        ModBlocks.initialize(Balm.getBlocks());
        ModBlockEntities.initialize();
        ModItems.initialize(Balm.getItems());
        ModMenus.initialize();
        ModWorldGen.initialize(Balm.getWorldGen());
        ModCommands.initialize(Balm.getCommands());
        ModComponents.initialize(Balm.getComponents());
        Balm.initializeIfLoaded((String)"bluemap", (String)"net.blay09.mods.waystones.compat.BlueMapIntegration");
        Balm.initializeIfLoaded((String)"dynmap", (String)"net.blay09.mods.waystones.compat.DynmapIntegration");
        Balm.initializeIfLoaded((String)"unbreakables", (String)"net.blay09.mods.waystones.compat.UnbreakablesIntegration");
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

