/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter.network;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncBlacklistPacket(Set<String> blacklistedItems) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBlacklistPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"auto_pickup_filter", (String)"sync_blacklist"));
    public static final StreamCodec<FriendlyByteBuf, SyncBlacklistPacket> CODEC = StreamCodec.of(SyncBlacklistPacket::write, SyncBlacklistPacket::read);

    public static void write(FriendlyByteBuf buf, SyncBlacklistPacket packet) {
        buf.writeVarInt(packet.blacklistedItems.size());
        for (String item : packet.blacklistedItems) {
            buf.writeUtf(item);
        }
    }

    public static SyncBlacklistPacket read(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        HashSet<String> items = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            items.add(buf.readUtf());
        }
        return new SyncBlacklistPacket(items);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

