/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter.network;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.night.auto_pickup_filter.PickupFilterManager;
import net.night.auto_pickup_filter.network.SyncBlacklistPacket;
import net.night.auto_pickup_filter.network.SyncOverridePacket;

public class NetworkHandler {
    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), SyncBlacklistPacket.TYPE, SyncBlacklistPacket.CODEC, (packet, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PickupFilterManager.setServerBlacklist(serverPlayer.getUUID(), packet.blacklistedItems());
            }
        }));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), SyncOverridePacket.TYPE, SyncOverridePacket.CODEC, (packet, context) -> context.queue(() -> {
            Player patt0$temp = context.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PickupFilterManager.setServerOverride(serverPlayer.getUUID(), packet.override());
            }
        }));
    }

    public static void sendBlacklistToServer() {
        SyncBlacklistPacket packet = new SyncBlacklistPacket(PickupFilterManager.getBlacklistedItems());
        NetworkManager.sendToServer((CustomPacketPayload)packet);
    }

    public static void sendOverrideToServer(boolean override) {
        SyncOverridePacket packet = new SyncOverridePacket(override);
        NetworkManager.sendToServer((CustomPacketPayload)packet);
    }
}

