/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter.mixin;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.night.auto_pickup_filter.PickupFilterManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    public Player player;

    @Inject(method={"add(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (PickupFilterManager.isBlacklistedForPlayer(this.player, stack)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddItemAtSlot(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (PickupFilterManager.isBlacklistedForPlayer(this.player, stack)) {
            cir.setReturnValue((Object)false);
        }
    }
}

