/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.base;

import earth.terrarium.handcrafted.common.blocks.base.SittableBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.ModularSeatProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class ModularSeatBlock
extends HorizontalDirectionalBlock
implements SittableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<ModularSeatProperty> SHAPE = EnumProperty.create((String)"shape", ModularSeatProperty.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ModularSeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)ModularSeatProperty.SINGLE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, FACING, WATERLOGGED});
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        ModularSeatProperty couchShape = (ModularSeatProperty)((Object)state.getValue(SHAPE));
        switch (mirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                ModularSeatProperty shape = switch (couchShape) {
                    case ModularSeatProperty.OUTER_LEFT -> ModularSeatProperty.OUTER_RIGHT;
                    case ModularSeatProperty.OUTER_RIGHT -> ModularSeatProperty.OUTER_LEFT;
                    case ModularSeatProperty.INNER_LEFT -> ModularSeatProperty.INNER_RIGHT;
                    case ModularSeatProperty.INNER_RIGHT -> ModularSeatProperty.INNER_LEFT;
                    default -> couchShape;
                };
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)((Object)shape));
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                ModularSeatProperty shape = switch (couchShape) {
                    case ModularSeatProperty.OUTER_LEFT -> ModularSeatProperty.OUTER_RIGHT;
                    case ModularSeatProperty.OUTER_RIGHT -> ModularSeatProperty.OUTER_LEFT;
                    case ModularSeatProperty.INNER_LEFT -> ModularSeatProperty.INNER_LEFT;
                    case ModularSeatProperty.INNER_RIGHT -> ModularSeatProperty.INNER_RIGHT;
                    default -> couchShape;
                };
                return (BlockState)state.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)((Object)shape));
            }
        }
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return direction.getAxis().isHorizontal() ? (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)level, currentPos))) : super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.sitOn(level, pos, player, (Direction)state.getValue((Property)FACING))) {
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.CONSUME_PARTIAL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)context.getLevel(), pos)));
    }

    public boolean canTakeShape(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        BlockState other = level.getBlockState(pos.relative(face));
        return !other.is((Block)this) || other.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    public ModularSeatProperty getShape(BlockState state, BlockGetter level, BlockPos pos) {
        Direction dir;
        Direction dir2;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState state1 = level.getBlockState(pos.relative(direction.getOpposite()));
        if (state1.is((Block)this) && (dir2 = (Direction)state1.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.canTakeShape(state, level, pos, dir2)) {
            return dir2 == direction.getCounterClockWise() ? ModularSeatProperty.OUTER_LEFT : ModularSeatProperty.OUTER_RIGHT;
        }
        BlockState state2 = level.getBlockState(pos.relative(direction));
        if (state2.is((Block)this) && (dir = (Direction)state2.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.canTakeShape(state, level, pos, dir.getOpposite())) {
            return dir == direction.getCounterClockWise() ? ModularSeatProperty.INNER_LEFT : ModularSeatProperty.INNER_RIGHT;
        }
        BlockState state3 = level.getBlockState(pos.relative(direction.getClockWise().getOpposite()));
        BlockState state4 = level.getBlockState(pos.relative(direction.getClockWise()));
        if (!state3.is((Block)this) && !state4.is((Block)this)) {
            return ModularSeatProperty.SINGLE;
        }
        if (!state3.is((Block)this)) {
            return ModularSeatProperty.RIGHT;
        }
        if (!state4.is((Block)this)) {
            return ModularSeatProperty.LEFT;
        }
        return ModularSeatProperty.MIDDLE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

