/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.render.entity;

import com.github.L_Ender.cataclysm.client.model.entity.Axe_Blade_Model;
import com.github.L_Ender.cataclysm.client.render.CMRenderTypes;
import com.github.L_Ender.cataclysm.entity.projectile.Axe_Blade_Entity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Axe_Blade_Renderer
extends EntityRenderer<Axe_Blade_Entity> {
    private static final ResourceLocation[] TEXTURE_PROGRESS = new ResourceLocation[5];
    public Axe_Blade_Model model = new Axe_Blade_Model();

    public Axe_Blade_Renderer(EntityRendererProvider.Context manager) {
        super(manager);
        for (int i = 0; i < 5; ++i) {
            Axe_Blade_Renderer.TEXTURE_PROGRESS[i] = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)("textures/entity/draugar/axe_blade_" + i + ".png"));
        }
    }

    protected int getBlockLightLevel(Axe_Blade_Entity entity, BlockPos pos) {
        return 15;
    }

    public void render(Axe_Blade_Entity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        matrixStackIn.translate(0.0f, 0.0f, 0.0f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(entityIn.getYRot() + 180.0f));
        VertexConsumer vertexconsumer = bufferIn.getBuffer(CMRenderTypes.getGhost(this.getTextureLocation(entityIn)));
        this.model.setupAnim(entityIn, 0.0f, 0.0f, (float)entityIn.tickCount + partialTicks, 0.0f, 0.0f);
        float hide = (float)entityIn.getTransparency() / 80.0f;
        float alpha = 1.0f - hide;
        int i = FastColor.ARGB32.color((int)Mth.floor((float)(alpha * 255.0f)), (int)-1);
        this.model.renderToBuffer(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, i);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Axe_Blade_Entity entity) {
        return this.getGrowingTexture(entity, (int)((float)entity.tickCount * 0.5f % 4.0f));
    }

    public ResourceLocation getGrowingTexture(Axe_Blade_Entity entity, int age) {
        return TEXTURE_PROGRESS[Mth.clamp((int)age, (int)0, (int)4)];
    }
}

