/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.misc.IAttachmentType;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedData;
import net.mehvahdjukaar.moonlight.api.misc.WorldSavedDataType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.neoforge.RegHelperImpl;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.misc.AttachmentBuilderImpl;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class RegHelper {
    private static final List<ResourceLocation> DEFAULT_AFTER_ENTRIES = List.of(CreativeModeTabs.SPAWN_EGGS.location());

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.register(name, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void registerInBatch(Registry<T> reg, Consumer<Registrator<T>> eventListener) {
        void var1_1;
        RegHelperImpl.registerInBatch(reg, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> registerAsync(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerAsync(name, var1_1, var2_2);
    }

    public static <T extends Block> RegSupplier<T> registerBlock(ResourceLocation name, Supplier<T> block) {
        return RegHelper.register(name, block, Registries.BLOCK);
    }

    public static <T extends Block> RegSupplier<T> registerBlockWithItem(ResourceLocation name, Supplier<T> blockFactory) {
        return RegHelper.registerBlockWithItem(name, blockFactory, new Item.Properties());
    }

    public static <T extends Block> RegSupplier<T> registerBlockWithItem(ResourceLocation name, Supplier<T> blockFactory, Item.Properties properties) {
        RegSupplier block = RegHelper.registerBlock(name, blockFactory);
        RegHelper.registerItem(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public static <T extends SimpleCriterionTrigger<?>> RegSupplier<T> registerTriggerType(ResourceLocation name, Supplier<T> instance) {
        return RegHelper.register(name, instance, Registries.TRIGGER_TYPE);
    }

    @Deprecated(forRemoval=true)
    public static <T extends PlacementModifierType<?>> RegSupplier<T> registerPlacementModifier(ResourceLocation name, Supplier<T> instance) {
        return RegHelper.register(name, instance, Registries.PLACEMENT_MODIFIER_TYPE);
    }

    public static <T extends PlacementModifier> RegSupplier<PlacementModifierType<T>> registerPlacementModifier(ResourceLocation name, MapCodec<T> codec) {
        return RegHelper.register(name, () -> () -> codec, Registries.PLACEMENT_MODIFIER_TYPE);
    }

    public static <T extends LootPoolEntryContainer> RegSupplier<LootPoolEntryType> registerLootPoolEntry(ResourceLocation name, Supplier<MapCodec<T>> instance) {
        return RegHelper.register(name, () -> new LootPoolEntryType((MapCodec)instance.get()), Registries.LOOT_POOL_ENTRY_TYPE);
    }

    public static <T extends LootItemCondition> RegSupplier<LootItemConditionType> registerLootCondition(ResourceLocation name, Supplier<MapCodec<T>> instance) {
        return RegHelper.register(name, () -> new LootItemConditionType((MapCodec)instance.get()), Registries.LOOT_CONDITION_TYPE);
    }

    public static <T> Supplier<DataComponentType<T>> registerDataComponent(ResourceLocation name, Supplier<DataComponentType<T>> component) {
        return RegHelper.register(name, component, Registries.DATA_COMPONENT_TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> Supplier<EntityDataSerializer<T>> registerEntityDataSerializer(ResourceLocation name, Supplier<EntityDataSerializer<T>> serializer) {
        void var1_1;
        return RegHelperImpl.registerEntityDataSerializer(name, var1_1);
    }

    public static RegSupplier<VillagerProfession> registerVillagerProfession(ResourceLocation name, Predicate<Holder<PoiType>> heldJobSite, Predicate<Holder<PoiType>> acquirableJobSite, ImmutableSet<Item> requestedItems, ImmutableSet<Block> secondaryWorkSite, @Nullable Supplier<SoundEvent> workSound) {
        Supplier<VillagerProfession> factory = () -> new VillagerProfession(name.getPath(), heldJobSite, acquirableJobSite, requestedItems, secondaryWorkSite, workSound == null ? null : (SoundEvent)workSound.get());
        return RegHelper.register(name, factory, Registries.VILLAGER_PROFESSION);
    }

    public static RegSupplier<VillagerProfession> registerVillagerProfession(ResourceLocation name, Supplier<PoiType> heldJobSite, Supplier<PoiType> acquirableJobSite, ImmutableSet<Item> requestedItems, ImmutableSet<Block> secondaryPoi, @Nullable Supplier<SoundEvent> workSound) {
        return RegHelper.registerVillagerProfession(name, (Holder<PoiType> holder) -> holder.value() == heldJobSite.get(), (Holder<PoiType> holder) -> holder.value() == acquirableJobSite.get(), requestedItems, secondaryPoi, workSound);
    }

    public static <T extends StructurePoolElement> Supplier<StructurePoolElementType<T>> registerStructurePoolElement(ResourceLocation id, MapCodec<T> codec) {
        return RegHelper.register(id, () -> () -> codec, Registries.STRUCTURE_POOL_ELEMENT);
    }

    public static RegSupplier<StructurePieceType> registerStructurePiece(ResourceLocation name, StructurePieceType pieceType) {
        return RegHelper.register(name, () -> pieceType, Registries.STRUCTURE_PIECE);
    }

    public static <T extends StructureProcessor> RegSupplier<StructureProcessorType<T>> registerStructurePiece(ResourceLocation name, MapCodec<T> codec) {
        return RegHelper.register(name, () -> () -> codec, Registries.STRUCTURE_PROCESSOR);
    }

    public static <T extends StructurePlacement> RegSupplier<StructurePlacementType<T>> registerStructurePlacementType(ResourceLocation name, MapCodec<T> codec) {
        return RegHelper.register(name, () -> () -> codec, Registries.STRUCTURE_PLACEMENT);
    }

    public static RegSupplier<StructurePieceType> register(ResourceLocation name, StructurePieceType pieceType) {
        return RegHelper.register(name, () -> pieceType, Registries.STRUCTURE_PIECE);
    }

    public static RegSupplier<PoiType> registerPOI(ResourceLocation name, Supplier<PoiType> poi) {
        return RegHelper.register(name, poi, Registries.POINT_OF_INTEREST_TYPE);
    }

    public static RegSupplier<PoiType> registerPOI(ResourceLocation name, int searchDistance, int maxTickets, Block ... blocks) {
        return RegHelper.registerPOI(name, () -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Block block : blocks) {
                builder.addAll((Iterable)block.getStateDefinition().getPossibleStates());
            }
            return new PoiType((Set)builder.build(), searchDistance, maxTickets);
        });
    }

    @SafeVarargs
    public static RegSupplier<PoiType> registerPOI(ResourceLocation name, int searchDistance, int maxTickets, Supplier<Block> ... blocks) {
        return RegHelper.registerPOI(name, () -> {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Supplier block : blocks) {
                builder.addAll((Iterable)((Block)block.get()).getStateDefinition().getPossibleStates());
            }
            return new PoiType((Set)builder.build(), searchDistance, maxTickets);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(forRemoval=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addBlocksToPOI(ResourceKey<PoiType> poi, Iterable<? extends Block> blocks) {
        void var1_1;
        RegHelperImpl.addBlocksToPOI(poi, (Iterable<? extends Block>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addExtraPOIStatesRegistration(Consumer<ExtraPOIStatesEvent> eventListener) {
        RegHelperImpl.addExtraPOIStatesRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addExtraBEBlockStatesRegistration(Consumer<ExtraBEStatesEvent> eventListener) {
        RegHelperImpl.addExtraBEBlockStatesRegistration(eventListener);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Fluid> RegSupplier<T> registerFluid(ResourceLocation name, Supplier<T> fluid) {
        void var1_1;
        return RegHelperImpl.registerFluid(name, var1_1);
    }

    public static <T extends Item> RegSupplier<T> registerItem(ResourceLocation name, Supplier<T> item) {
        return RegHelper.register(name, item, Registries.ITEM);
    }

    public static <T extends Feature<?>> RegSupplier<T> registerFeature(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.register(name, feature, Registries.FEATURE);
    }

    public static <T extends StructureType<?>> RegSupplier<T> registerStructure(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.registerAsync(name, feature, Registries.STRUCTURE_TYPE);
    }

    public static <T extends SoundEvent> RegSupplier<T> registerSound(ResourceLocation name, Supplier<T> sound) {
        return RegHelper.register(name, sound, Registries.SOUND_EVENT);
    }

    public static RegSupplier<SoundEvent> registerSound(ResourceLocation name) {
        return RegHelper.registerSound(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)name));
    }

    public static RegSupplier<SoundEvent> registerSound(ResourceLocation name, float fixedRange) {
        return RegHelper.registerSound(name, () -> SoundEvent.createFixedRangeEvent((ResourceLocation)name, (float)fixedRange));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <C extends AbstractContainerMenu> RegSupplier<MenuType<C>> registerMenuType(ResourceLocation name, TriFunction<Integer, Inventory, FriendlyByteBuf, C> containerFactory) {
        void var1_1;
        return RegHelperImpl.registerMenuType(name, var1_1);
    }

    public static <T extends MobEffect> RegSupplier<T> registerEffect(ResourceLocation name, Supplier<T> effect) {
        return RegHelper.register(name, effect, Registries.MOB_EFFECT);
    }

    public static <T extends Enchantment> RegSupplier<T> registerEnchantment(ResourceLocation name, Supplier<T> enchantment) {
        return RegHelper.register(name, enchantment, Registries.ENCHANTMENT);
    }

    public static <T extends SensorType<? extends Sensor<?>>> RegSupplier<T> registerSensor(ResourceLocation name, Supplier<T> sensorType) {
        return RegHelper.register(name, sensorType, Registries.SENSOR_TYPE);
    }

    public static <T extends Sensor<?>> RegSupplier<SensorType<T>> registerSensorI(ResourceLocation name, Supplier<T> sensor) {
        return RegHelper.register(name, () -> new SensorType(sensor), Registries.SENSOR_TYPE);
    }

    public static <T extends Activity> RegSupplier<T> registerActivity(ResourceLocation name, Supplier<T> activity) {
        return RegHelper.register(name, activity, Registries.ACTIVITY);
    }

    public static RegSupplier<Activity> registerActivity(ResourceLocation name) {
        return RegHelper.registerActivity(name, () -> new Activity(name.getPath()));
    }

    public static <T extends Schedule> RegSupplier<T> registerSchedule(ResourceLocation name, Supplier<T> schedule) {
        return RegHelper.register(name, schedule, Registries.SCHEDULE);
    }

    public static <T extends MemoryModuleType<?>> RegSupplier<T> registerMemoryModule(ResourceLocation name, Supplier<T> memory) {
        return RegHelper.register(name, memory, Registries.MEMORY_MODULE_TYPE);
    }

    public static <U> RegSupplier<MemoryModuleType<U>> registerMemoryModule(ResourceLocation name, @Nullable Codec<U> codec) {
        return RegHelper.register(name, () -> new MemoryModuleType(Optional.ofNullable(codec)), Registries.MEMORY_MODULE_TYPE);
    }

    public static <T extends RecipeSerializer<?>> RegSupplier<T> registerRecipeSerializer(ResourceLocation name, Supplier<T> recipe) {
        return RegHelper.register(name, recipe, Registries.RECIPE_SERIALIZER);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends CraftingRecipe> RegSupplier<RecipeSerializer<T>> registerSpecialRecipe(ResourceLocation name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
        void var1_1;
        return RegHelperImpl.registerSpecialRecipe(name, var1_1);
    }

    public static <T extends Recipe<?>> Supplier<RecipeType<T>> registerRecipeType(ResourceLocation name) {
        return RegHelper.register(name, () -> {
            final String id = name.toString();
            return new RecipeType<T>(){

                public String toString() {
                    return id;
                }
            };
        }, Registries.RECIPE_TYPE);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> RegSupplier<T> registerBlockEntityType(ResourceLocation name, Supplier<T> blockEntity) {
        return RegHelper.register(name, blockEntity, Registries.BLOCK_ENTITY_TYPE);
    }

    public static <E extends BlockEntity> RegSupplier<BlockEntityType<E>> registerBlockEntityType(ResourceLocation name, BiFunction<BlockPos, BlockState, E> blockEntitySupplier, Block ... blocks) {
        return RegHelper.registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply, blocks));
    }

    @SafeVarargs
    public static <E extends BlockEntity> RegSupplier<BlockEntityType<E>> registerBlockEntityType(ResourceLocation name, BiFunction<BlockPos, BlockState, E> blockEntitySupplier, Supplier<? extends Block> ... blocks) {
        return RegHelper.registerBlockEntityType(name, () -> PlatHelper.newBlockEntityType(blockEntitySupplier::apply, (Block[])Arrays.stream(blocks).map(Supplier::get).toArray(Block[]::new)));
    }

    public static <A> Registry<A> registerRegistry(ResourceLocation key, boolean synced) {
        return RegHelper.registerRegistry(ResourceKey.createRegistryKey((ResourceLocation)key), synced);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <A> Registry<A> registerRegistry(ResourceKey<Registry<A>> key, boolean synced) {
        void var1_1;
        return RegHelperImpl.registerRegistry(key, (boolean)var1_1);
    }

    public static <A extends WorldSavedData> WorldSavedDataType<A> registerWorldSavedData(ResourceLocation key, Function<ServerLevel, A> constructor, Codec<A> codec, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, A> networkCodec) {
        return RegHelper.registerWorldSavedData(key, constructor, codec, networkCodec, false);
    }

    public static <A extends WorldSavedData> WorldSavedDataType<A> registerWorldSavedData(ResourceLocation key, Function<ServerLevel, A> constructor, Codec<A> codec, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, A> networkCodec, boolean perLevel) {
        WorldSavedDataType instance = new WorldSavedDataType(key, constructor, codec, networkCodec, perLevel ? WorldSavedDataType.Scope.PER_LEVEL : WorldSavedDataType.Scope.SINGLE_OVERWORLD);
        RegHelper.register(key, () -> instance, MoonlightRegistry.WORLD_SAVED_DATA_TYPE_REGISTRY.key());
        return instance;
    }

    public static RegSupplier<SimpleParticleType> registerParticle(ResourceLocation name) {
        return RegHelper.register(name, PlatHelper::newSimpleParticle, Registries.PARTICLE_TYPE);
    }

    public static <T extends ParticleOptions> RegSupplier<ParticleType<T>> registerParticle(ResourceLocation name, MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        return RegHelper.register(name, () -> PlatHelper.newParticle(codec, streamCodec, false), Registries.PARTICLE_TYPE);
    }

    public static <T extends ParticleOptions> RegSupplier<ParticleType<T>> registerParticle(ResourceLocation name, boolean overrideLimiter, Function<ParticleType<T>, MapCodec<T>> codecGetter, Function<ParticleType<T>, StreamCodec<? super RegistryFriendlyByteBuf, T>> streamCodecGetter) {
        return RegHelper.register(name, () -> PlatHelper.newParticle(codecGetter, streamCodecGetter, overrideLimiter), Registries.PARTICLE_TYPE);
    }

    public static <T extends LootItemFunction> RegSupplier<LootItemFunctionType<T>> registerLootFunction(ResourceLocation name, MapCodec<T> codec) {
        return RegHelper.register(name, () -> new LootItemFunctionType(codec), Registries.LOOT_FUNCTION_TYPE);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.Builder<T> builder) {
        return RegHelper.register(name, () -> builder.build(name.getPath()), Registries.ENTITY_TYPE);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, Supplier<EntityType<T>> type) {
        return RegHelper.register(name, type, Registries.ENTITY_TYPE);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height) {
        return RegHelper.registerEntityType(name, factory, category, width, height, 5);
    }

    @Deprecated(forRemoval=true)
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange) {
        return RegHelper.registerEntityType(name, factory, category, width, height, clientTrackingRange, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(forRemoval=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, int updateInterval) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerEntityType(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4, (int)var5_5, (int)var6_6);
    }

    public static RegSupplier<ArmorMaterial> registerArmorMaterial(ResourceLocation name, int totalDefense, Supplier<Ingredient> ingredient, int enchValue, Supplier<Holder<SoundEvent>> sound, float toughness, float knockbackResistance) {
        return RegHelper.register(name, () -> new ArmorMaterial(RegHelper.calculateStandardDefence(totalDefense), enchValue, (Holder)sound.get(), ingredient, List.of(new ArmorMaterial.Layer(name)), toughness, knockbackResistance), Registries.ARMOR_MATERIAL);
    }

    private static EnumMap<ArmorItem.Type, Integer> calculateStandardDefence(int totalDefense) {
        EnumMap<ArmorItem.Type, Integer> defenseMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        LinkedHashMap<ArmorItem.Type, Double> proportions = new LinkedHashMap<ArmorItem.Type, Double>();
        proportions.put(ArmorItem.Type.CHESTPLATE, 0.41);
        proportions.put(ArmorItem.Type.LEGGINGS, 0.32);
        proportions.put(ArmorItem.Type.HELMET, 0.14);
        proportions.put(ArmorItem.Type.BOOTS, 0.13);
        for (Map.Entry entry : proportions.entrySet()) {
            ArmorItem.Type type = (ArmorItem.Type)entry.getKey();
            int defenseValue = (int)((Double)entry.getValue() * (double)totalDefense);
            defenseMap.put(type, defenseValue);
        }
        int remainder = totalDefense - defenseMap.values().stream().mapToInt(Integer::intValue).sum();
        block1: while (remainder > 0) {
            for (Map.Entry entry : proportions.entrySet()) {
                ArmorItem.Type type = (ArmorItem.Type)entry.getKey();
                int maxDefense = (int)Math.ceil((Double)entry.getValue() * (double)totalDefense);
                int currentDefense = defenseMap.get(type);
                if (currentDefense >= maxDefense) continue;
                defenseMap.put(type, currentDefense + 1);
                if (--remainder > 0) continue;
                continue block1;
            }
        }
        defenseMap.put(ArmorItem.Type.BODY, (Integer)defenseMap.get(ArmorItem.Type.CHESTPLATE) + (Integer)defenseMap.get(ArmorItem.Type.BOOTS));
        return defenseMap;
    }

    @Deprecated(forRemoval=true)
    public static void registerCompostable(ItemLike itemLike, float chance) {
        ComposterBlock.COMPOSTABLES.put((Object)itemLike.asItem(), chance);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(forRemoval=true)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemBurnTime(Item item, int burnTime) {
        void var1_1;
        RegHelperImpl.registerItemBurnTime(item, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockFlammability(Block item, int igniteOdds, int burnOdds) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerBlockFlammability(item, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSimpleRecipeCondition(ResourceLocation id, Predicate<String> predicate) {
        void var1_1;
        RegHelperImpl.registerSimpleRecipeCondition(id, (Predicate<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void registerDataPackRegistry(ResourceKey<Registry<T>> registryKey, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerDataPackRegistry(registryKey, var1_1, var2_2);
    }

    public static <T> ResourceKey<Registry<T>> registerDataPackRegistry(ResourceLocation id, Codec<T> codec, @Nullable Codec<T> networkCodec) {
        ResourceKey key = ResourceKey.createRegistryKey((ResourceLocation)id);
        RegHelper.registerDataPackRegistry(key, codec, networkCodec);
        return key;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, boolean searchBar, List<ResourceLocation> afterTabs, List<ResourceLocation> beforeTabs, Consumer<CreativeModeTab.Builder> configurator) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerCreativeModeTab(name, (boolean)var1_1, (List<ResourceLocation>)var2_2, (List<ResourceLocation>)var3_3, (Consumer<CreativeModeTab.Builder>)var4_4);
    }

    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, Consumer<CreativeModeTab.Builder> configurator) {
        return RegHelper.registerCreativeModeTab(name, false, configurator);
    }

    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, boolean searchBar, Consumer<CreativeModeTab.Builder> configurator) {
        return RegHelper.registerCreativeModeTab(name, searchBar, DEFAULT_AFTER_ENTRIES, List.of(), configurator);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addItemsToTabsRegistration(Consumer<ItemToTabEvent> event) {
        RegHelperImpl.addItemsToTabsRegistration(event);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addAttributeRegistration(Consumer<AttributeEvent> eventListener) {
        RegHelperImpl.addAttributeRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addSpawnPlacementsRegistration(Consumer<SpawnPlacementEvent> eventListener) {
        RegHelperImpl.addSpawnPlacementsRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommandRegistration(CommandRegistration eventListener) {
        RegHelperImpl.addCommandRegistration(eventListener);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerBaseBlockSet(baseName, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerReducedBlockSet(baseName, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.STAIRS, VariantType.SLAB}, baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, Block parentBlock) {
        return RegHelper.registerFullBlockSet(baseName, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parentBlock));
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties) {
        return RegHelper.registerBlockSet(VariantType.values(), baseName, properties);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBlockSet(VariantType[] types, ResourceLocation baseName, BlockBehaviour.Properties properties) {
        if (!new ArrayList<VariantType>(List.of(types)).contains((Object)VariantType.BLOCK)) {
            throw new IllegalStateException("Must contain base variant type");
        }
        RegSupplier<Block> block = RegHelper.registerBlock(baseName, () -> VariantType.BLOCK.create(properties, null));
        RegHelper.registerItem(baseName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        EnumMap<VariantType, Supplier<Block>> m = RegHelper.registerBlockSet(types, block, baseName.getNamespace());
        m.put(VariantType.BLOCK, block);
        return m;
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBlockSet(VariantType[] types, RegSupplier<? extends Block> baseBlock, String modId) {
        ResourceLocation baseName = baseBlock.getId();
        EnumMap<VariantType, Supplier<Block>> map = new EnumMap<VariantType, Supplier<Block>>(VariantType.class);
        for (VariantType type : types) {
            if (type.equals((Object)VariantType.BLOCK)) continue;
            Object name = baseName.getPath();
            name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            ResourceLocation blockId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)name);
            RegSupplier<Block> block = RegHelper.registerBlock(blockId, () -> type.create(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)baseBlock.get())), baseBlock::get));
            RegHelper.registerItem(blockId, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            map.put(type, block);
        }
        return map;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addLootTableInjects(Consumer<LootInjectEvent> eventListener) {
        RegHelperImpl.addLootTableInjects(eventListener);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerFireworkRecipe(FireworkExplosion.Shape shape, Item ingredient) {
        void var1_1;
        RegHelperImpl.registerFireworkRecipe(shape, (Item)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void startRegisteringFor(Object bus) {
        RegHelperImpl.startRegisteringFor(bus);
    }

    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener) {
        DispenserHelper.addListener(eventListener, DispenserHelper.Priority.NORMAL);
    }

    public static void addDynamicDispenserBehaviorRegistration(Consumer<DispenserHelper.Event> eventListener, DispenserHelper.Priority priority) {
        DispenserHelper.addListener(eventListener, priority);
    }

    public static void registerDynamicItemListingSerializer(ResourceLocation id, MapCodec<? extends ModItemListing> trade) {
        ItemListingManager.registerSerializer(id, trade);
    }

    public static void registerDynamicItemListingSerializer(ResourceLocation id, VillagerTrades.ItemListing instance, int level) {
        ItemListingManager.registerSimple(id, instance, level);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerResourcePackSource(PackType packType, RepositorySource packSource) {
        void var1_1;
        RegHelperImpl.registerResourcePackSource(packType, (RepositorySource)var1_1);
    }

    public static void registerResourcePack(PackType packType, Supplier<Pack> packSupplier) {
        if (packSupplier == null) {
            return;
        }
        RegHelper.registerResourcePackSource(packType, loader -> {
            Pack t = (Pack)packSupplier.get();
            if (t != null) {
                loader.accept(t);
            }
        });
    }

    public static void registerDynamicResourceProvider(DynamicResourcesProvider provider) {
        DynamicResourcesInternals.registerProvider(provider);
        SimplePackProvider packSupplier = provider;
        PackType packType = provider.getPackType();
        if (packType == PackType.CLIENT_RESOURCES) {
            SimplePackProvider maybeMerged = MoonlightClient.mergePackSupplier(provider);
            if (maybeMerged == null) {
                return;
            }
            packSupplier = maybeMerged;
        }
        RegHelper.registerResourcePack(packType, packSupplier::createPack);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <A, T> IAttachmentType<A, T> registerDataAttachment(ResourceLocation id, Supplier<AttachmentBuilder<A>> config, Class<T> targetClass) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerDataAttachment(id, var1_1, var2_2);
    }

    @Deprecated(forRemoval=true)
    public static <A> IAttachmentType<A, Object> regDataAttachment(ResourceLocation id, Supplier<AttachmentBuilder<A>> config) {
        return RegHelper.registerDataAttachment(id, config, Object.class);
    }

    public static enum VariantType {
        BLOCK(Block::new),
        STAIRS(ModStairBlock::new),
        SLAB(SlabBlock::new),
        WALL(WallBlock::new);

        private final BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        public Block create(BlockBehaviour.Properties properties, @Nullable Supplier<Block> parent) {
            return this.constructor.apply(parent, properties);
        }

        public static void addToTab(ItemToTabEvent event, Map<VariantType, Supplier<Block>> blocks) {
            EnumMap<VariantType, Supplier<Block>> m = new EnumMap<VariantType, Supplier<Block>>(blocks);
            event.add((ResourceKey<CreativeModeTab>)CreativeModeTabs.BUILDING_BLOCKS, (ItemLike[])m.values().stream().map(Supplier::get).toArray(Block[]::new));
        }
    }

    @ApiStatus.NonExtendable
    public static interface AttachmentBuilder<A> {
        public static <A> AttachmentBuilder<A> create(Supplier<A> initializer) {
            return new AttachmentBuilderImpl<A>(initializer);
        }

        public AttachmentBuilder<A> persistent(Codec<A> var1);

        public AttachmentBuilder<A> copyOnDeath();

        public AttachmentBuilder<A> syncWith(StreamCodec<? super RegistryFriendlyByteBuf, A> var1, BiPredicate<Object, ServerPlayer> var2);

        default public AttachmentBuilder<A> syncWith(StreamCodec<? super RegistryFriendlyByteBuf, A> packetCodec) {
            return this.syncWith(packetCodec, (provider, player) -> true);
        }
    }

    public static interface LootInjectEvent {
        public ResourceLocation getTable();

        public void addTableReference(ResourceLocation var1);
    }

    @FunctionalInterface
    public static interface CommandRegistration {
        public void accept(CommandDispatcher<CommandSourceStack> var1, CommandBuildContext var2, Commands.CommandSelection var3);
    }

    @FunctionalInterface
    public static interface SpawnPlacementEvent {
        public <T extends Mob> void register(EntityType<T> var1, SpawnPlacementType var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }

    @FunctionalInterface
    public static interface AttributeEvent {
        public void register(EntityType<? extends LivingEntity> var1, AttributeSupplier.Builder var2);
    }

    public static interface ItemToTabEvent {
        public CreativeModeTab.ItemDisplayParameters getParameters();

        public CreativeModeTab getTab();

        public void addItems(ResourceKey<CreativeModeTab> var1, @Nullable Predicate<ItemStack> var2, boolean var3, List<ItemStack> var4);

        default public void add(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.addAfter(tab, null, items);
        }

        default public void add(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            this.addAfter(tab, null, items);
        }

        default public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemLike i : items) {
                if (i.asItem().getDefaultInstance().isEmpty()) {
                    throw new IllegalStateException("Attempted to add empty item " + String.valueOf(i) + " to item tabs. It's likely that some mod tried to call asItem before items were registered\");");
                }
                stacks.add(i.asItem().getDefaultInstance());
            }
            this.addItems(tab, target, true, stacks);
        }

        default public void addAfter(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.addItems(tab, target, true, List.of(items));
        }

        default public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemLike ... items) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemLike i : items) {
                if (i.asItem().getDefaultInstance().isEmpty()) {
                    throw new IllegalStateException("Attempted to add empty item " + String.valueOf(i) + " to item tabs. It's likely that some mod tried to call asItem before items were registered");
                }
                stacks.add(i.asItem().getDefaultInstance());
            }
            this.addItems(tab, target, false, stacks);
        }

        default public void addBefore(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target, ItemStack ... items) {
            this.addItems(tab, target, false, List.of(items));
        }

        default public void remove(ResourceKey<CreativeModeTab> tab, ItemLike ... items) {
            this.remove(tab, (ItemStack stack) -> {
                for (ItemLike i : items) {
                    if (!stack.is(i.asItem())) continue;
                    return true;
                }
                return false;
            });
        }

        default public void remove(ResourceKey<CreativeModeTab> tab, ItemStack ... items) {
            this.remove(tab, (ItemStack stack) -> {
                for (ItemStack i : items) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)i)) continue;
                    return true;
                }
                return false;
            });
        }

        public void remove(ResourceKey<CreativeModeTab> var1, Predicate<ItemStack> var2);
    }

    public static interface ExtraBEStatesEvent {
        public void addBlocks(BlockEntityType<?> var1, Block ... var2);
    }

    public static interface ExtraPOIStatesEvent {
        @Deprecated(forRemoval=true)
        default public void addStatesToPoi(ResourceKey<PoiType> typeKey, Set<BlockState> states) {
            this.addStates(typeKey, states);
        }

        @Deprecated(forRemoval=true)
        default public void addBlockToPoi(ResourceKey<PoiType> typeKey, Block block) {
            this.addBlock(typeKey, block);
        }

        public void addBlock(ResourceKey<PoiType> var1, Block var2);

        public void addStates(ResourceKey<PoiType> var1, Set<BlockState> var2);

        default public void addBlocks(ResourceKey<PoiType> typeKey, Collection<Block> blocks) {
            for (Block b : blocks) {
                this.addBlock(typeKey, b);
            }
        }
    }
}

