/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class IItemHandlerBEBase
extends BlockEntity
implements Nameable {
    private Component customName;
    public final IItemHandler handler = this.createItemHandler();

    public IItemHandlerBEBase(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    @Nonnull
    protected abstract IItemHandler createItemHandler();

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        CompoundTag invTag = tag.getCompound("inv");
        ((INBTSerializable)this.handler).deserializeNBT(provider, (Tag)invTag);
        if (tag.contains("CustomName", 8)) {
            this.customName = IItemHandlerBEBase.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        CompoundTag compound = (CompoundTag)((INBTSerializable)this.handler).serializeNBT(provider);
        if (compound != null) {
            tag.put("inv", (Tag)compound);
        }
        if (this.hasCustomName()) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        super.saveAdditional(tag, provider);
    }

    @Nonnull
    public Component getName() {
        return this.customName != null ? this.customName : Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    @Nonnull
    public Component getDisplayName() {
        return this.getName();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }
}

