/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.events;

import com.jkvin114.displaydelight.block.AbstractStackablePlatedFoodBlock;
import com.jkvin114.displaydelight.block.SmallPlatedFoodBlock;
import com.jkvin114.displaydelight.events.InterationManager;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayTags;
import com.jkvin114.displaydelight.init.PlatedBlocks;
import com.jkvin114.displaydelight.init.SmallPlatedBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="displaydelight")
public class DisplayEvents {
    private static boolean shouldCancelUseEventClient = false;
    private static boolean shouldCancelUseEventServer = false;

    @SubscribeEvent
    public static void on(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof Player && DisplayEvents.isPlateDisplayable(event.getItem())) {
            Level lvl = event.getEntity().m_9236_();
            if (shouldCancelUseEventServer && !lvl.f_46443_) {
                shouldCancelUseEventServer = false;
                event.setCanceled(true);
                System.out.println("cancel server");
            }
            if (shouldCancelUseEventClient && lvl.f_46443_) {
                shouldCancelUseEventClient = false;
                event.setCanceled(true);
                System.out.println("cancel client");
            }
        }
    }

    private static boolean isPlateDisplayable(ItemStack item) {
        return item.m_204117_(DisplayTags.SMALL_PLATE_DISPLAYABLE) || item.m_204117_(DisplayTags.PLATE_DISPLAYABLE);
    }

    @SubscribeEvent
    public static void onCheck(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().m_41619_()) {
                InterationManager.tryTakeItemWithBareHand(event.getEntity(), slevel, event.getHitVec());
                return;
            }
        }
        if (!((level = event.getLevel()) instanceof ServerLevel)) {
            BlockPos pos = event.getHitVec().m_82425_();
            BlockState state = event.getLevel().m_8055_(pos);
            if (!DisplayEvents.isPlateDisplayable(event.getItemStack())) {
                return;
            }
            if (state.m_60713_((Block)DisplayBlocks.SMALL_PLATE.get()) || state.m_60713_((Block)DisplayBlocks.PLATE.get()) || state.m_60734_() instanceof AbstractStackablePlatedFoodBlock || state.m_60734_() instanceof SmallPlatedFoodBlock) {
                System.out.println("set cancel");
                shouldCancelUseEventClient = true;
                shouldCancelUseEventServer = true;
            }
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        boolean placed = false;
        if (event.getItemStack().m_204117_(DisplayTags.SMALL_PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnSmallPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().m_204117_(DisplayTags.PLATE_DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItemOnPlate(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        if (!placed && event.getItemStack().m_204117_(DisplayTags.DISPLAYABLE)) {
            placed = InterationManager.tryPlaceItem(event.getEntity(), level2, event.getHitVec(), event.getHand() == InteractionHand.MAIN_HAND);
        }
        event.setResult(Event.Result.ALLOW);
        if (placed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            List drops;
            Block[] array;
            ServerLevel lvl = (ServerLevel)levelAccessor;
            for (Block target : array = DisplayBlocks.getAll()) {
                drops = Block.m_49869_((BlockState)target.m_49966_(), (ServerLevel)lvl, (BlockPos)BlockPos.m_274561_((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.get(0)).m_204117_(DisplayTags.DISPLAYABLE)) continue;
                BlockAssociations.addToMap(((ItemStack)drops.get(0)).m_41720_(), target, false);
            }
            for (Block target : PlatedBlocks.getAll()) {
                drops = Block.m_49869_((BlockState)target.m_49966_(), (ServerLevel)lvl, (BlockPos)BlockPos.m_274561_((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.get(0)).m_204117_(DisplayTags.PLATE_DISPLAYABLE)) continue;
                BlockAssociations.addToMap(((ItemStack)drops.get(0)).m_41720_(), target, true);
            }
            for (Block target : SmallPlatedBlocks.getAll()) {
                drops = Block.m_49869_((BlockState)target.m_49966_(), (ServerLevel)lvl, (BlockPos)BlockPos.m_274561_((double)0.0, (double)256.0, (double)0.0), null);
                if (drops.isEmpty() || !((ItemStack)drops.get(0)).m_204117_(DisplayTags.SMALL_PLATE_DISPLAYABLE)) continue;
                BlockAssociations.addSmallPlateToMap(((ItemStack)drops.get(0)).m_41720_(), target);
            }
        }
    }
}

