/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.corpsecurioscompat.util;

import com.leclowndu93150.corpsecurioscompat.data.CuriosSlotDataComponent;
import com.leclowndu93150.corpsecurioscompat.duck.ICuriosAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DelayedCurioHandler {
    private static final Map<UUID, List<ItemStack>> pendingItems = new HashMap<UUID, List<ItemStack>>();
    private static final Map<UUID, Long> scheduledTimes = new HashMap<UUID, Long>();

    public static void scheduleCurioRestoration(Player player, List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        UUID playerId = player.m_20148_();
        pendingItems.put(playerId, new ArrayList<ItemStack>(items));
        long currentTime = System.currentTimeMillis();
        long executeTime = currentTime + 50L;
        scheduledTimes.put(playerId, executeTime);
    }

    public static void tickForPlayer(Player player) {
        UUID playerId = player.m_20148_();
        Long scheduledTime = scheduledTimes.get(playerId);
        if (scheduledTime == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= scheduledTime) {
            DelayedCurioHandler.processPendingItems(player);
            scheduledTimes.remove(playerId);
        }
    }

    private static void processPendingItems(Player player) {
        UUID playerId = player.m_20148_();
        List<ItemStack> items = pendingItems.remove(playerId);
        if (items == null || items.isEmpty()) {
            return;
        }
        LazyOptional curiosOptional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        if (!curiosOptional.isPresent()) {
            return;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)curiosOptional.resolve().get();
        Map curios = handler.getCurios();
        for (ICurioStacksHandler stacksHandler : curios.values()) {
            if (!(stacksHandler instanceof ICuriosAccessor)) continue;
            ICuriosAccessor accessor = (ICuriosAccessor)stacksHandler;
            accessor.corpsecurioscompat$forceSlotRebuild();
        }
        for (ItemStack stack : items) {
            if (DelayedCurioHandler.tryEquipCurio(stack, player, curios) || player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
    }

    private static boolean tryEquipCurio(ItemStack stack, Player player, Map<String, ICurioStacksHandler> curios) {
        ItemStack existingStack;
        IDynamicStackHandler targetStacks;
        int availableSlots;
        if (stack.m_41619_()) {
            return false;
        }
        CuriosSlotDataComponent.CurioSlotData slotData = CuriosSlotDataComponent.getCurioSlotData(stack);
        if (slotData == null) {
            return false;
        }
        String slotType = slotData.slotType();
        int slotIndex = slotData.slotIndex();
        ICurioStacksHandler handler = curios.get(slotType);
        if (handler != null && slotIndex >= 0 && slotIndex < (availableSlots = (targetStacks = slotData.isCosmetic() ? handler.getCosmeticStacks() : handler.getStacks()).getSlots()) && (existingStack = targetStacks.getStackInSlot(slotIndex)).m_41619_()) {
            ItemStack cleanStack = stack.m_41777_();
            CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
            targetStacks.setStackInSlot(slotIndex, cleanStack);
            return true;
        }
        return DelayedCurioHandler.tryFindAlternativeSlot(stack, curios);
    }

    private static boolean tryFindAlternativeSlot(ItemStack stack, Map<String, ICurioStacksHandler> curios) {
        CuriosSlotDataComponent.CurioSlotData slotData = CuriosSlotDataComponent.getCurioSlotData(stack);
        if (slotData == null) {
            return false;
        }
        for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
            if (!CuriosApi.getCuriosHelper().getCurioTags(stack.m_41720_()).contains(entry.getKey())) continue;
            ICurioStacksHandler handler = entry.getValue();
            for (int pass = 0; pass < 2; ++pass) {
                IDynamicStackHandler stacks = pass == 0 ? (slotData.isCosmetic() ? handler.getCosmeticStacks() : handler.getStacks()) : (slotData.isCosmetic() ? handler.getStacks() : handler.getCosmeticStacks());
                for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                    try {
                        if (!stacks.getStackInSlot(slot).m_41619_()) continue;
                        ItemStack cleanStack = stack.m_41777_();
                        CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
                        stacks.setStackInSlot(slot, cleanStack);
                        return true;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public static void cleanupPlayer(Player player) {
        UUID playerId = player.m_20148_();
        List<ItemStack> items = pendingItems.remove(playerId);
        scheduledTimes.remove(playerId);
        if (items != null && !items.isEmpty()) {
            for (ItemStack stack : items) {
                if (stack.m_41619_()) continue;
                ItemStack cleanStack = stack.m_41777_();
                CuriosSlotDataComponent.removeCurioSlotData(cleanStack);
                if (player.m_150109_().m_36054_(cleanStack)) continue;
                player.m_36176_(cleanStack, false);
            }
        }
    }
}

