/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.registry;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tech.muddykat.engineered_schematics.block.SchematicCorkBoard;
import tech.muddykat.engineered_schematics.block.SchematicDeskBlock;
import tech.muddykat.engineered_schematics.block.entity.SchematicBoardBlockEntity;
import tech.muddykat.engineered_schematics.block.entity.SchematicTableBlockEntity;
import tech.muddykat.engineered_schematics.item.ESSchematicSettings;
import tech.muddykat.engineered_schematics.item.SchematicItem;
import tech.muddykat.engineered_schematics.item.SchematicTableBlockItem;

public class ESRegistry {
    private static final DeferredRegister<BlockEntityType<?>> TE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"engineered_schematics");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"engineered_schematics");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"engineered_schematics");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"engineered_schematics");
    public static RegistryObject<BlockEntityType<SchematicTableBlockEntity>> SCHEMATIC_TABLE_TYPE;
    public static RegistryObject<BlockEntityType<SchematicBoardBlockEntity>> SCHEMATIC_BOARD_TYPE;
    public static RegistryObject<Block> BLOCK_SCHEMATIC_TABLE;
    public static RegistryObject<Item> SCHEMATIC_ITEM;
    public static RegistryObject<BlockItem> BLOCK_ITEM_SCHEMATIC_TABLE;
    public static RegistryObject<Block> BLOCK_CORKBOARD;
    public static RegistryObject<BlockItem> BLOCK_ITEM_CORKBOARD;
    public static final RegistryObject<CreativeModeTab> TAB;

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TE_REGISTER.register(bus);
        CREATIVE_MODE_TABS.register(bus);
    }

    public static void getDisplayItems(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)BLOCK_ITEM_SCHEMATIC_TABLE.get());
        for (MultiblockHandler.IMultiblock mb : IEMultiblocks.IE_MULTIBLOCKS) {
            ItemStack blueprint = new ItemStack((ItemLike)SCHEMATIC_ITEM.get());
            ESSchematicSettings settings = new ESSchematicSettings(blueprint);
            settings.setMultiblock(mb);
            settings.setMirror(false);
            settings.setRotation(Rotation.NONE);
            settings.setPlaced(false);
            settings.applyTo(blueprint);
            output.m_246342_(blueprint);
        }
    }

    public static void initialize() {
        SCHEMATIC_ITEM = ITEMS.register("multiblock_schematic", SchematicItem::new);
        BLOCK_SCHEMATIC_TABLE = BLOCKS.register("schematic_table_block", () -> new SchematicDeskBlock<SchematicTableBlockEntity>(SCHEMATIC_TABLE_TYPE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 5.0f).m_60955_()));
        SCHEMATIC_TABLE_TYPE = TE_REGISTER.register("schematic_table_type", ESRegistry.makeType(SchematicTableBlockEntity::new, BLOCK_SCHEMATIC_TABLE));
        BLOCK_ITEM_SCHEMATIC_TABLE = ITEMS.register("schematic_table_block", () -> new SchematicTableBlockItem((Block)BLOCK_SCHEMATIC_TABLE.get()));
        BLOCK_ITEM_CORKBOARD = ITEMS.register("corkboard", () -> new BlockItem((Block)BLOCK_CORKBOARD.get(), new Item.Properties()));
        BLOCK_CORKBOARD = BLOCKS.register("corkboard", SchematicCorkBoard::new);
        SCHEMATIC_BOARD_TYPE = TE_REGISTER.register("corkboard_type", ESRegistry.makeType(SchematicBoardBlockEntity::new, () -> (Block)BLOCK_CORKBOARD.get()));
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeType(BlockEntityType.BlockEntitySupplier<T> create, Supplier<? extends Block> valid) {
        return ESRegistry.makeTypeMultipleBlocks(create, (Collection<? extends Supplier<? extends Block>>)ImmutableSet.of(valid));
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeTypeMultipleBlocks(BlockEntityType.BlockEntitySupplier<T> create, Collection<? extends Supplier<? extends Block>> valid) {
        return () -> new BlockEntityType(create, (Set)ImmutableSet.copyOf((Collection)valid.stream().map(Supplier::get).collect(Collectors.toList())), null);
    }

    static {
        TAB = CREATIVE_MODE_TABS.register("engineered_schematics", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.engineered_schematics")).m_257737_(() -> ((BlockItem)BLOCK_ITEM_SCHEMATIC_TABLE.get()).m_7968_()).m_257501_(ESRegistry::getDisplayItems).m_257652_());
    }
}

