/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.menu;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.gui.IEBaseContainerOld;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.mixin.accessors.ContainerAccess;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import tech.muddykat.engineered_schematics.block.entity.SchematicTableBlockEntity;
import tech.muddykat.engineered_schematics.menu.SchematicInventory;

public class SchematicsContainerMenu
extends IEBaseContainerOld<SchematicTableBlockEntity> {
    public static final int MAX_NUM_DYNAMIC_SLOTS = 8;
    public final Inventory inventoryPlayer;
    public SchematicInventory inventorySchematic;
    private final Level world;
    public int selected_schematic = 0;
    public final List<TemplateMultiblock> availableMultiblocks = MultiblockHandler.getMultiblocks().stream().filter(mb -> mb instanceof TemplateMultiblock).map(mb -> (TemplateMultiblock)mb).toList();
    public Boolean isMirroredSchematic;

    public SchematicsContainerMenu(MenuType<?> type, int id, Inventory inventoryPlayer, SchematicTableBlockEntity tile) {
        super(type, (BlockEntity)tile, id);
        this.inventoryPlayer = inventoryPlayer;
        this.world = tile.getLevelNonnull();
        this.selected_schematic = 0;
        this.isMirroredSchematic = false;
        this.inventorySchematic = new SchematicInventory(this, List.of((MultiblockHandler.IMultiblock)this.availableMultiblocks.get(this.selected_schematic)));
        this.rebindSlots();
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 35 + j * 18, 137 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 35 + i * 18, 195));
        }
    }

    public void rebindSlots() {
        Screen currentScreen;
        this.f_38839_.clear();
        ((ContainerAccess)this).getLastSlots().clear();
        ((ContainerAccess)this).getRemoteSlots().clear();
        assert (this.inv != null);
        this.m_38897_((Slot)new SchematicInputSlot(this, this.inv, 0, 144, 89, 64));
        this.ownSlotCount = 1;
        int amount_of_schematics = List.of(this.availableMultiblocks.get(this.selected_schematic)).size();
        this.inventorySchematic = new SchematicInventory(this, List.of((MultiblockHandler.IMultiblock)this.availableMultiblocks.get(this.selected_schematic)));
        if (this.inv.m_8020_(0).m_41613_() > 0) {
            for (int i = 0; i < amount_of_schematics; ++i) {
                TemplateMultiblock template = this.availableMultiblocks.get(i);
                int y = 89 + (i < 9 ? i / 3 : -(i - 6) / 3) * 18;
                this.m_38897_((Slot)new SchematicSlot((AbstractContainerMenu)this, this.inventorySchematic, this.inv, i, 190 + i % 3 * 18, y, template));
                ++this.ownSlotCount;
                this.inventorySchematic.updateOutputs(this.inv);
            }
        }
        while (this.ownSlotCount < 8) {
            this.m_38897_((Slot)new IESlot.AlwaysEmptySlot((AbstractContainerMenu)this));
            ++this.ownSlotCount;
        }
        this.bindPlayerInv(this.inventoryPlayer);
        if (FMLLoader.getDist().isClient() && (currentScreen = Minecraft.m_91087_().f_91080_) instanceof IEContainerScreen) {
            currentScreen.m_6575_(Minecraft.m_91087_(), currentScreen.f_96543_, currentScreen.f_96544_);
        }
    }

    public void nextSchematic() {
        this.selected_schematic = (this.selected_schematic + 1) % this.availableMultiblocks.size();
        this.inventorySchematic = new SchematicInventory(this, List.of((MultiblockHandler.IMultiblock)this.availableMultiblocks.get(this.selected_schematic)));
    }

    public void previousSchematic() {
        int toSelect = this.selected_schematic - 1;
        if (toSelect < 0) {
            toSelect = this.availableMultiblocks.size() - 1;
        }
        this.selected_schematic = toSelect;
        this.inventorySchematic = new SchematicInventory(this, List.of((MultiblockHandler.IMultiblock)this.availableMultiblocks.get(this.selected_schematic)));
    }

    public void flipSchematic() {
        this.isMirroredSchematic = this.isMirroredSchematic == false;
    }

    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        super.m_150399_(id, dragType, clickType, player);
        ((SchematicTableBlockEntity)this.tile).markContainingBlockForUpdate(null);
        if (!this.world.f_46443_) {
            this.m_38946_();
        }
    }

    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.m_128441_("index")) {
            int index = nbt.m_128451_("index");
            this.jumpToSchematic(index);
            this.rebindSlots();
        }
        if (nbt.m_128441_("mirrored")) {
            this.isMirroredSchematic = nbt.m_128471_("mirrored");
            this.rebindSlots();
        }
    }

    public Boolean getSchematicMirrorState() {
        return this.isMirroredSchematic;
    }

    public void jumpToSchematic(Integer index) {
        int toSelect = index;
        if (toSelect < 0) {
            toSelect = this.availableMultiblocks.size() - 1;
        }
        this.selected_schematic = toSelect % this.availableMultiblocks.size();
        this.inventorySchematic = new SchematicInventory(this, List.of((MultiblockHandler.IMultiblock)this.availableMultiblocks.get(this.selected_schematic)));
    }

    public static class SchematicInputSlot
    extends IESlot {
        int size;
        SchematicsContainerMenu schematicMenu;

        public SchematicInputSlot(SchematicsContainerMenu containerMenu, Container inv, int id, int x, int y, int size) {
            super((AbstractContainerMenu)containerMenu, inv, id, x, y);
            this.size = size;
            this.schematicMenu = containerMenu;
        }

        public boolean m_5857_(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return false;
            }
            return itemStack.m_41720_().equals(Items.f_42516_);
        }

        public int m_5866_(ItemStack stack) {
            return this.size;
        }

        public void m_6654_() {
            super.m_6654_();
            this.schematicMenu.rebindSlots();
        }

        public boolean m_8010_(Player pPlayer) {
            return true;
        }
    }

    public static class SchematicSlot
    extends IESlot {
        private final Container inputInventory;
        public final TemplateMultiblock template;

        public SchematicSlot(AbstractContainerMenu container, SchematicInventory inv, Container inputInventory, int id, int x, int y, TemplateMultiblock template) {
            super(container, (Container)inv, id, x, y);
            this.inputInventory = inputInventory;
            this.template = template;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public boolean m_8010_(@NotNull Player player) {
            return true;
        }

        public boolean m_6659_() {
            return this.m_6657_();
        }

        public void m_142406_(Player player, ItemStack stack) {
            ((SchematicInventory)this.f_40218_).reduceInputs(this.inputInventory, stack);
            super.m_142406_(player, stack);
        }
    }
}

