/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.menu;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.muddykat.engineered_schematics.EngineeredSchematics;
import tech.muddykat.engineered_schematics.item.ESSchematicSettings;
import tech.muddykat.engineered_schematics.menu.SchematicsContainerMenu;
import tech.muddykat.engineered_schematics.registry.ESRegistry;

public class SchematicInventory
extends SimpleContainer {
    private final List<MultiblockHandler.IMultiblock> schematics;
    private final SchematicsContainerMenu menu;
    private static ArrayList<MultiblockHandler.IMultiblock> exceptions = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger((String)"registry");

    public SchematicInventory(SchematicsContainerMenu container, List<MultiblockHandler.IMultiblock> schematics) {
        super(schematics.size());
        this.schematics = schematics;
        this.menu = container;
    }

    public void updateOutputs(Container inputInventory) {
        int i;
        NonNullList inputs = NonNullList.m_122780_((int)(inputInventory.m_6643_() - 1), (Object)ItemStack.f_41583_);
        for (i = 0; i < inputs.size(); ++i) {
            inputs.set(i, (Object)inputInventory.m_8020_(i));
        }
        if (((ItemStack)inputs.get(0)).m_41613_() > 0) {
            for (i = 0; i < this.schematics.size(); ++i) {
                MultiblockHandler.IMultiblock mb = this.schematics.get(i);
                if (mb instanceof TemplateMultiblock) {
                    TemplateMultiblock template = (TemplateMultiblock)mb;
                    ItemStack schematic = new ItemStack((ItemLike)ESRegistry.SCHEMATIC_ITEM.get());
                    ESSchematicSettings settings = new ESSchematicSettings(schematic);
                    settings.setMultiblock((MultiblockHandler.IMultiblock)template);
                    settings.setMirror(this.menu.isMirroredSchematic);
                    settings.setRotation(Rotation.NONE);
                    settings.setPlaced(false);
                    if (EngineeredSchematics.hasFormationItem(template.getUniqueName())) {
                        settings.setFormationTool(EngineeredSchematics.getFormationItem(template.getUniqueName()));
                    }
                    settings.applyTo(schematic);
                    this.m_6836_(i, schematic.m_41777_());
                    continue;
                }
                if (exceptions.contains(mb)) continue;
                exceptions.add(mb);
                logger.warn("An IMultiblock for the Schematic Table was not an instance of TemplateMultiblock [{}]", (Object)mb.getUniqueName());
            }
        }
    }

    private NonNullList<ItemStack> consumePaper(NonNullList<ItemStack> query, int crafted) {
        if (!query.isEmpty() && ((ItemStack)query.get(0)).m_41613_() > 0) {
            ItemStack paper = (ItemStack)query.get(0);
            if (paper.m_150930_(Items.f_42516_)) {
                int count = paper.m_41613_() - crafted;
                if (0 == count) {
                    query.set(0, (Object)ItemStack.f_41583_);
                }
                if (count > 0) {
                    paper.m_41764_(count);
                    query.set(0, (Object)paper.m_41777_());
                }
            } else {
                logger.warn("Schematic Table had an input that was not paper?");
            }
        }
        return query;
    }

    public void reduceInputs(Container inputInventory, ItemStack taken) {
        int i;
        NonNullList inputs = NonNullList.m_122780_((int)(inputInventory.m_6643_() - 1), (Object)ItemStack.f_41583_);
        for (i = 0; i < inputs.size(); ++i) {
            inputs.set(i, (Object)inputInventory.m_8020_(i));
        }
        this.consumePaper((NonNullList<ItemStack>)inputs, 1);
        for (i = 0; i < inputs.size(); ++i) {
            inputInventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        this.updateOutputs(inputInventory);
    }
}

