/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.item;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SchematicProjection {
    final MultiblockHandler.IMultiblock multiblock;
    final Level realWorld;
    final Level templateWorld;
    final StructurePlaceSettings settings = new StructurePlaceSettings();
    final Int2ObjectMap<List<StructureTemplate.StructureBlockInfo>> layers = new Int2ObjectArrayMap();
    final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    final int blockcount;
    boolean isDirty = true;

    public SchematicProjection(@Nonnull Level world, @Nonnull MultiblockHandler.IMultiblock multiblock) {
        Objects.requireNonNull(world, "World cannot be null!");
        Objects.requireNonNull(multiblock, "Multiblock cannot be null!");
        this.multiblock = multiblock;
        this.realWorld = world;
        List blocks = multiblock.getStructure(world);
        this.templateWorld = ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.getValue()).makeWorld(blocks, pos -> true, world.m_9598_());
        this.blockcount = blocks.size();
        for (StructureTemplate.StructureBlockInfo info : blocks) {
            ArrayList<StructureTemplate.StructureBlockInfo> list = (ArrayList<StructureTemplate.StructureBlockInfo>)this.layers.get(info.f_74675_().m_123342_());
            if (list == null) {
                list = new ArrayList<StructureTemplate.StructureBlockInfo>();
                this.layers.put(info.f_74675_().m_123342_(), list);
            }
            list.add(info);
        }
    }

    public SchematicProjection setRotation(Rotation rotation) {
        if (this.settings.m_74404_() != rotation) {
            this.settings.m_74379_(rotation);
            this.isDirty = true;
        }
        return this;
    }

    public SchematicProjection setFlip(boolean mirror) {
        Mirror m;
        Mirror mirror2 = m = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        if (this.settings.m_74401_() != m) {
            this.settings.m_74377_(m);
            this.isDirty = true;
        }
        return this;
    }

    public void reset() {
        this.settings.m_74379_(Rotation.NONE);
        this.settings.m_74377_(Mirror.NONE);
        this.offset.m_122178_(0, 0, 0);
    }

    public int getBlockCount() {
        return this.blockcount;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getLayerSize(int layer) {
        if (layer < 0 || layer >= this.layers.size()) {
            return 0;
        }
        return ((List)this.layers.get(layer)).size();
    }

    public Level getTemplateWorld() {
        return this.templateWorld;
    }

    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SchematicProjection) {
            SchematicProjection other = (SchematicProjection)obj;
            return this.multiblock.getUniqueName().equals((Object)other.multiblock.getUniqueName()) && this.settings.m_74401_() == other.settings.m_74401_() && this.settings.m_74404_() == other.settings.m_74404_();
        }
        return false;
    }

    public boolean process(int layer, Predicate<Info> predicate) {
        this.updateData();
        List blocks = (List)this.layers.get(layer);
        if (blocks == null) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo info : blocks) {
            if (!predicate.test(new Info(this, info))) continue;
            return true;
        }
        return false;
    }

    public boolean processAll(BiPredicate<Integer, Info> predicate) {
        this.updateData();
        for (int layer = 0; layer < this.getLayerCount(); ++layer) {
            List blocks = (List)this.layers.get(layer);
            for (StructureTemplate.StructureBlockInfo info : blocks) {
                if (!predicate.test(layer, new Info(this, info))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateData() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        boolean mirrored = this.settings.m_74401_() == Mirror.FRONT_BACK;
        Rotation rotation = this.settings.m_74404_();
        Vec3i size = this.multiblock.getSize(this.realWorld);
        if (!mirrored) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    this.offset.m_122178_(1 - size.m_123343_(), 0, 0);
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.m_122178_(1 - size.m_123341_(), 0, 1 - size.m_123343_());
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.offset.m_122178_(0, 0, 1 - size.m_123341_());
                    break;
                }
                default: {
                    this.offset.m_122178_(0, 0, 0);
                    break;
                }
            }
        } else {
            switch (rotation) {
                case NONE: {
                    this.offset.m_122178_(1 - size.m_123341_(), 0, 0);
                    break;
                }
                case CLOCKWISE_90: {
                    this.offset.m_122178_(1 - size.m_123343_(), 0, 1 - size.m_123341_());
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.m_122178_(0, 0, 1 - size.m_123343_());
                    break;
                }
                default: {
                    this.offset.m_122178_(0, 0, 0);
                }
            }
        }
        int x = (rotation.ordinal() % 2 == 0 ? size.m_123341_() : size.m_123343_()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.m_123343_() : size.m_123341_()) / 2;
        this.offset.m_122154_((Vec3i)this.offset, x, 0, z);
    }

    public BlockPos getRealPos(BlockPos offset) {
        List blocks = (List)this.layers.get(0);
        Iterator iterator = blocks.iterator();
        if (iterator.hasNext()) {
            StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)iterator.next();
            Info inf = new Info(this, info);
            return inf.tPos.m_121955_((Vec3i)offset);
        }
        return offset;
    }

    public static final class Info {
        public final StructurePlaceSettings settings;
        public final MultiblockHandler.IMultiblock multiblock;
        public final BlockPos tPos;
        public final Level templateWorld;
        public final StructureTemplate.StructureBlockInfo tBlockInfo;

        public Info(SchematicProjection projection, StructureTemplate.StructureBlockInfo templateBlockInfo) {
            this.multiblock = projection.multiblock;
            this.templateWorld = projection.templateWorld;
            this.settings = projection.settings;
            this.tBlockInfo = templateBlockInfo;
            this.tPos = StructureTemplate.m_74563_((StructurePlaceSettings)this.settings, (BlockPos)templateBlockInfo.f_74675_()).m_121996_((Vec3i)projection.offset);
        }

        public BlockState getModifiedState(Level realWorld, BlockPos realPos) {
            return this.templateWorld.m_8055_(this.tBlockInfo.f_74675_()).m_60715_(this.settings.m_74401_()).rotate((LevelAccessor)realWorld, realPos, this.settings.m_74404_());
        }

        public BlockState getRawState() {
            return this.templateWorld.m_8055_(this.tBlockInfo.f_74675_());
        }
    }
}

