/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.item;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tech.muddykat.engineered_schematics.item.ESSchematicSettings;
import tech.muddykat.engineered_schematics.item.SchematicProjection;

public class SchematicItem
extends Item {
    public SchematicItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        ESSchematicSettings settings;
        String selfKey = this.m_5671_(stack);
        if (stack.m_41782_() && (settings = SchematicItem.getSettings(stack)).getMultiblock() != null) {
            Component name = settings.getMultiblock().getDisplayName();
            String key = selfKey + ".specific" + (settings.isMirrored() ? ".mirrored" : "");
            return Component.m_237110_((String)key, (Object[])new Object[]{name}).m_130940_(ChatFormatting.AQUA);
        }
        return Component.m_237115_((String)selfKey).m_130940_(ChatFormatting.AQUA);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        ESSchematicSettings settings = SchematicItem.getSettings(stack);
        if (settings.getMultiblock() != null) {
            assert (worldIn != null);
            Vec3i size = settings.getMultiblock().getSize(worldIn);
            tooltip.add((Component)Component.m_237110_((String)"desc.engineered_schematics.info.schematic.size", (Object[])new Object[]{Component.m_237113_((String)("[" + size.m_123341_() + "x" + size.m_123342_() + "x" + size.m_123343_() + "]"))}));
            MultiblockHandler.IMultiblock mb = settings.getMultiblock();
            String machine_tier_id = settings.getFormationTool().m_41778_();
            tooltip.add((Component)Component.m_237110_((String)"desc.engineered_schematics.info.schematic.tier", (Object[])new Object[]{Component.m_237115_((String)machine_tier_id).m_130940_(ChatFormatting.AQUA)}));
            tooltip.add((Component)Component.m_237110_((String)"desc.engineered_schematics.info.schematic.block_info", (Object[])new Object[]{Component.m_237117_((String)"shift").m_130940_(ChatFormatting.GOLD)}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"desc.engineered_schematics.info.schematic.no_multiblock"));
        }
    }

    public static ESSchematicSettings getSettings(@Nullable ItemStack stack) {
        return new ESSchematicSettings(stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        Level level = context.m_43725_();
        InteractionHand hand = context.m_43724_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_().m_7494_();
        ItemStack stack = player.m_21120_(hand);
        ESSchematicSettings settings = SchematicItem.getSettings(stack);
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            settings.setPos(pos);
            settings.setPlaced(true);
            settings.applyTo(stack);
            if (player.m_6144_()) {
                Rotation rot = player.m_6350_().equals((Object)Direction.NORTH) ? Rotation.NONE : (player.m_6350_().equals((Object)Direction.EAST) ? Rotation.CLOCKWISE_90 : (player.m_6350_().equals((Object)Direction.WEST) ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_180));
                settings.setRotation(rot);
                settings.applyTo(stack);
                player.m_5661_((Component)Component.m_237115_((String)"desc.engineered_schematics.info.schematic.rotated"), true);
                player.m_5661_((Component)Component.m_237115_((String)"desc.engineered_schematics.info.schematic.moved"), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ESSchematicSettings settings = SchematicItem.getSettings(stack);
        BlockPos pos = settings.getPos();
        if (player.m_6144_() && player.m_7500_() && pos != null && settings.getMultiblock() != null) {
            BlockPos.MutableBlockPos hit = pos.m_122032_();
            if (!level.f_46443_) {
                BiPredicate<Integer, SchematicProjection.Info> pred = (layer, info) -> {
                    BlockPos realPos = info.tPos.m_121955_((Vec3i)hit);
                    BlockState to_state = info.getModifiedState(level, realPos);
                    level.m_46597_(realPos, to_state);
                    return false;
                };
                SchematicProjection projection = new SchematicProjection(level, settings.getMultiblock());
                projection.setFlip(settings.isMirrored());
                projection.setRotation(settings.getRotation());
                projection.processAll(pred);
                player.m_5661_((Component)Component.m_237115_((String)"desc.engineered_schematics.info.schematic.placed"), true);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

