/*
 * Decompiled with CFR 0.152.
 */
package tech.muddykat.engineered_schematics.client.screen;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonCheckbox;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import tech.muddykat.engineered_schematics.EngineeredSchematics;
import tech.muddykat.engineered_schematics.block.entity.SchematicTableBlockEntity;
import tech.muddykat.engineered_schematics.menu.SchematicsContainerMenu;

public class SchematicsScreen
extends IEContainerScreen<SchematicsContainerMenu> {
    private static final ResourceLocation TEXTURE = EngineeredSchematics.makeTextureLocation("schematic_gui");
    private static final int MAX_DISPLAY_WIDTH = 80;
    private static final int TEXT_COLOR = 0x666666;
    private GuiButtonCheckbox mirrorSchematicBtn;
    private SchematicScrollPanel selectionPanel;
    private float scrollAmount;

    public SchematicsScreen(SchematicsContainerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title, TEXTURE);
        this.f_97727_ = 218;
        this.f_97726_ = 230;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97729_ = 9;
        this.f_97728_ = 14;
        this.f_97730_ = 36;
        this.f_97731_ = 125;
        this.initMirrorButton();
        this.initSelectionPanel();
    }

    private void initMirrorButton() {
        this.mirrorSchematicBtn = (GuiButtonCheckbox)this.m_142416_((GuiEventListener)new GuiButtonCheckbox(this.f_97735_ + 129, this.f_97736_ + 112, Component.m_237115_((String)"engineered_schematics.gui.schematic_table.mirror").getString(), () -> ((SchematicsContainerMenu)this.f_97732_).isMirroredSchematic, this::handleMirrorButton));
    }

    private void handleMirrorButton(GuiButtonState<Boolean> btn) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("mirrored", (Boolean)btn.getState() == false);
        this.handleMirrorButtonClick(tag);
    }

    private void initSelectionPanel() {
        this.selectionPanel = (SchematicScrollPanel)this.m_142416_((GuiEventListener)new SchematicScrollPanel(this.f_96541_, 110, 92, this.f_97736_ + 20, this.f_97735_ + 9, ((SchematicsContainerMenu)this.f_97732_).availableMultiblocks, this::handleSchematicSelection, index -> index == ((SchematicsContainerMenu)this.f_97732_).selected_schematic, amount -> {
            this.scrollAmount = amount.floatValue();
            return true;
        }));
        this.selectionPanel.setScrollAmount(this.scrollAmount);
    }

    private boolean handleSchematicSelection(int index) {
        this.f_96541_.m_6937_(() -> ((SchematicsContainerMenu)this.f_97732_).jumpToSchematic(index));
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("index", index);
        this.sendUpdateToServer(nbt);
        return true;
    }

    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((SchematicsContainerMenu)this.f_97732_).availableMultiblocks.isEmpty()) {
            return;
        }
        TemplateMultiblock mb = ((SchematicsContainerMenu)this.f_97732_).availableMultiblocks.get(((SchematicsContainerMenu)this.f_97732_).selected_schematic);
        PoseStack pose = graphics.m_280168_();
        this.drawMultiblockName(graphics, pose, mb);
        pose.m_85836_();
        this.renderManualMultimodel(pose, graphics, mb);
        pose.m_85849_();
    }

    private void drawMultiblockName(GuiGraphics graphics, PoseStack pose, TemplateMultiblock mb) {
        float textWidth = this.f_96547_.m_92724_(mb.getDisplayName().m_7532_());
        float scale = textWidth > 80.0f ? 80.0f / textWidth : 1.0f;
        pose.m_85836_();
        pose.m_85837_((double)this.f_97735_ + 174.5, (double)this.f_97736_ + 8.5 * (double)(2.0f + scale - scale * 2.0f), 0.0);
        pose.m_85841_(scale, scale, scale);
        graphics.m_280614_(this.f_96547_, mb.getDisplayName(), -this.f_96547_.m_92724_(mb.getDisplayName().m_7532_()) / 2, 0, 0x666666, false);
        pose.m_85849_();
    }

    public void renderManualMultimodel(PoseStack pose, GuiGraphics graphics, TemplateMultiblock mb) {
        SchematicTableBlockEntity tile = (SchematicTableBlockEntity)((SchematicsContainerMenu)this.m_6262_()).tile;
        if (tile == null) {
            return;
        }
        Level level = tile.m_58904_();
        if (level == null) {
            return;
        }
        ClientMultiblocks.MultiblockManualData renderProperties = ClientMultiblocks.get((MultiblockHandler.IMultiblock)mb);
        List structure = mb.getStructure(level);
        int[] structureDimensions = this.calculateStructureDimensions(structure);
        int structureHeight = structureDimensions[0];
        int structureWidth = structureDimensions[1];
        int structureLength = structureDimensions[2];
        float maxDimension = Math.max(structureHeight, Math.max(structureWidth, structureLength));
        pose.m_85836_();
        float scale = mb.getManualScale() * 0.65f;
        float renderPosX = (float)this.f_97735_ + 174.5f;
        float renderPosY = (float)this.f_97736_ + 54.5f;
        pose.m_252880_(renderPosX, renderPosY, maxDimension);
        pose.m_85841_(scale, -scale, 1.0f);
        Transformation additionalTransform = this.createRenderTransform();
        pose.pushTransformation(additionalTransform);
        pose.m_252781_(new Quaternionf().rotateXYZ(0.0f, 1.5707964f, 0.0f));
        pose.m_252880_((float)structureLength / -2.0f, (float)structureHeight / -2.0f, (float)structureWidth / -2.0f);
        if (renderProperties.canRenderFormedStructure()) {
            pose.m_85836_();
            renderProperties.renderFormedStructure(pose, (MultiBufferSource)graphics.m_280091_());
            pose.m_85849_();
        }
        pose.m_85849_();
    }

    private int[] calculateStructureDimensions(List<StructureTemplate.StructureBlockInfo> structure) {
        int structureHeight = 0;
        int structureWidth = 0;
        int structureLength = 0;
        for (StructureTemplate.StructureBlockInfo block : structure) {
            structureHeight = Math.max(structureHeight, block.f_74675_().m_123342_() + 1);
            structureWidth = Math.max(structureWidth, block.f_74675_().m_123343_() + 1);
            structureLength = Math.max(structureLength, block.f_74675_().m_123341_() + 1);
        }
        return new int[]{structureHeight, structureWidth, structureLength};
    }

    private Transformation createRenderTransform() {
        return new Transformation(null, new Quaternionf().rotateXYZ((float)Math.toRadians(25.0), 0.0f, 0.0f), null, new Quaternionf().rotateXYZ(0.0f, (float)Math.toRadians(-45.0), 0.0f));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        try {
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x666666, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x666666, false);
    }

    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
    }

    private void handleMirrorButtonClick(CompoundTag nbt) {
        if (!nbt.m_128456_()) {
            this.sendUpdateToServer(nbt);
            ((SchematicsContainerMenu)this.m_6262_()).flipSchematic();
        }
    }

    @NotNull
    protected List<InfoArea> makeInfoAreas() {
        ArrayList<InfoArea> areas = new ArrayList<InfoArea>();
        return areas;
    }

    public static class SchematicScrollPanel
    extends ScrollPanel {
        private final List<TemplateMultiblock> schematics;
        private final int entryHeight;
        private final Minecraft client;
        private final Function<Integer, Boolean> callback;
        private final Function<Integer, Boolean> isSelectedCallback;
        private final Function<Float, Boolean> updateScroller;

        public SchematicScrollPanel(Minecraft client, int width, int height, int top, int left, List<TemplateMultiblock> schematics, Function<Integer, Boolean> select_callback, Function<Integer, Boolean> isSelectedCallback, Function<Float, Boolean> updateScroller) {
            super(client, width, height, top, left);
            this.schematics = schematics;
            this.entryHeight = 20;
            this.client = client;
            this.callback = select_callback;
            this.isSelectedCallback = isSelectedCallback;
            this.updateScroller = updateScroller;
        }

        public void setScrollAmount(float scroll) {
            this.scrollDistance = scroll;
        }

        protected int getContentHeight() {
            return this.schematics.size() * (this.entryHeight + 1);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (mouseX < (double)this.left || mouseY < (double)this.top || mouseX > (double)(this.left + this.width) || mouseY > (double)(this.top + this.height)) {
                return false;
            }
            int y = (int)(mouseY - (double)this.top + (double)this.scrollDistance);
            int index = y / (this.entryHeight + 1);
            if (index >= 0 && index < this.schematics.size()) {
                this.updateScroller.apply(Float.valueOf(this.scrollDistance));
                return this.callback.apply(index);
            }
            return false;
        }

        protected void drawPanel(GuiGraphics graphics, int entryRight, int scrollY, Tesselator tesselator, int mouseX, int mouseY) {
            int y = scrollY - 2;
            PoseStack pose = graphics.m_280168_();
            Font font = this.client.f_91062_;
            for (int i = 0; i < this.schematics.size(); ++i) {
                boolean hover;
                TemplateMultiblock template = this.schematics.get(i);
                float textWidth = font.m_92724_(template.getDisplayName().m_7532_());
                float fScale = textWidth > 80.0f ? 80.0f / textWidth : 1.0f;
                int entryTop = y + i * (this.entryHeight + 1);
                int entryBottom = entryTop + this.entryHeight;
                graphics.m_280218_(TEXTURE, this.left, entryTop, 1, 219, 104, 20);
                boolean bl = hover = mouseY > entryTop && mouseY < entryBottom && this.m_5953_(mouseX, mouseY);
                int color = this.isSelectedCallback.apply(i) != false ? 0xFFFFFF : (hover ? 0xAAFFAA : 0x666666);
                pose.m_85836_();
                pose.m_252880_((float)(this.left + 10), (float)entryTop + 6.0f * (2.0f + fScale - fScale * 2.0f), 0.0f);
                pose.m_85836_();
                pose.m_85841_(fScale, fScale, fScale);
                graphics.m_280614_(font, template.getDisplayName(), 0, 0, color, false);
                pose.m_85849_();
                pose.m_85849_();
            }
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
        }
    }
}

