/*
 * Decompiled with CFR 0.152.
 */
package pm.meh.icterine.mixin;

import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pm.meh.icterine.Common;
import pm.meh.icterine.iface.IItemStackMixin;
import pm.meh.icterine.impl.StackSizeThresholdManager;
import pm.meh.icterine.util.LogHelper;

@Mixin(value={InventoryChangeTrigger.class})
abstract class InventoryChangeTriggerMixin {
    InventoryChangeTriggerMixin() {
    }

    @Inject(method={"trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void trigger(ServerPlayer serverPlayer, Inventory inventory, ItemStack itemStack, CallbackInfo ci) {
        if (itemStack.m_41619_() && Common.config.IGNORE_TRIGGERS_FOR_EMPTIED_STACKS || Common.config.IGNORE_TRIGGERS_FOR_DECREASED_STACKS && itemStack.m_41613_() < ((IItemStackMixin)itemStack).icterine$getPreviousStackSize() || Common.config.OPTIMIZE_TRIGGERS_FOR_INCREASED_STACKS && !StackSizeThresholdManager.doesStackPassThreshold(itemStack)) {
            ci.cancel();
            LogHelper.debug(() -> "InventoryChangeTrigger cancelled for %s".formatted(itemStack));
        } else {
            LogHelper.debug(() -> "InventoryChangeTrigger passed for %s".formatted(itemStack));
        }
    }
}

