/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.module.base;

import insane96mcp.insanelib.InsaneLib;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.mixin.ServerLevelAccessor;
import insane96mcp.insanelib.util.IntegratedPack;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="insanelib:base", canBeDisabled=false)
public class BaseFeature
extends Feature {
    @Config(description="If true, game time and day time, and weather will not advance if no players are online. This can break anything that relies on game time.")
    public static Boolean preventTimeTickingIfNoPlayersOnline = true;
    @Config(description="If true, also prevents game time from advancing if no players are online with Time Control installed")
    public static Boolean timeControlIntegration = true;
    @Config(description="If true, also prevents seasons from advancing if no players are online with Serene Seasons installed")
    public static Boolean sereneSeasonsIntegration = true;
    static int tick = 0;
    public static CommandFunction.CacheableFunction STOP = null;
    public static CommandFunction.CacheableFunction TC = null;
    public static CommandFunction.CacheableFunction SEASONS = null;

    @Override
    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        IntegratedPack.addServerPack("insanelib", "no_player_time_stop", "InsaneLib's No Player Time Stop", () -> preventTimeTickingIfNoPlayersOnline);
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        this.setTickTime(event.getEntity().m_20194_(), false, server -> server.m_6846_().m_11314_().size() > 1);
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedInEvent event) {
        this.setTickTime(event.getEntity().m_20194_(), true, null);
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (!preventTimeTickingIfNoPlayersOnline.booleanValue()) {
            return;
        }
        if (++tick <= 20) {
            return;
        }
        tick = 0;
        ServerFunctionManager functions = event.getServer().m_129890_();
        this.executeFunction(functions, STOP, "insanelib:stop_if_no_player_online");
        if (ModList.get().isLoaded("timecontrol") && timeControlIntegration.booleanValue()) {
            this.executeFunction(functions, TC, "insanelib:stop_time_if_no_player_online_tc");
        }
        if (ModList.get().isLoaded("sereneseasons") && sereneSeasonsIntegration.booleanValue()) {
            this.executeFunction(functions, SEASONS, "insanelib:stop_season_if_no_player_online");
        }
    }

    private void executeFunction(ServerFunctionManager functions, CommandFunction.CacheableFunction function, String id) {
        Optional func;
        if (function == null) {
            function = new CommandFunction.CacheableFunction(ResourceLocation.parse((String)id));
        }
        if ((func = function.m_78002_(functions)).isPresent()) {
            functions.m_136112_((CommandFunction)func.get(), functions.m_136129_());
        } else {
            InsaneLib.LOGGER.warn("{} function not found", (Object)id);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        this.setTickTime(event.getServer(), false, null);
    }

    public void setTickTime(@Nullable MinecraftServer server, boolean tickTime, @Nullable Predicate<MinecraftServer> extraConditions) {
        if (!preventTimeTickingIfNoPlayersOnline.booleanValue() || server == null || extraConditions != null && extraConditions.test(server)) {
            return;
        }
        ((ServerLevelAccessor)server.m_129783_()).setTickTime(tickTime);
    }
}

