/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.ConfigOption;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.LogHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class Feature {
    private String name;
    private String dataKeyPath = null;
    private String description;
    private ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    private Module module;
    private boolean enabledByDefault;
    private boolean canBeDisabled;
    private boolean enabled;
    HashMap<Field, ConfigOption<?>> configOptions = new HashMap();

    @Deprecated
    public Feature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        this.init(module, enabledByDefault, canBeDisabled);
    }

    protected Feature() {
    }

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        this.module = module;
        this.enabledByDefault = enabledByDefault;
        this.canBeDisabled = canBeDisabled;
        this.name = this.extractName();
        this.description = this.extractDescription();
        this.registerEvents();
    }

    private String extractName() {
        String name;
        if (this.getClass().isAnnotationPresent(LoadFeature.class) && !(name = this.getClass().getAnnotation(LoadFeature.class).name()).isBlank()) {
            return name;
        }
        if (this.getClass().isAnnotationPresent(Label.class)) {
            LogHelper.warn("Feature %s uses deprecated @Label annotation. Requires migration to @LoadFeature".formatted(this.getClass().getSimpleName()), new Object[0]);
            return this.getClass().getAnnotation(Label.class).name();
        }
        return Feature.fieldNameToConfigOption(this.getClass().getSimpleName()).replaceAll("(?i)feature", "").trim();
    }

    private String extractDescription() {
        if (this.getClass().isAnnotationPresent(LoadFeature.class)) {
            return this.getClass().getAnnotation(LoadFeature.class).description();
        }
        if (this.getClass().isAnnotationPresent(Label.class)) {
            LogHelper.warn("Feature %s uses deprecated @Label annotation. Requires migration to @LoadFeature".formatted(this.getClass().getSimpleName()), new Object[0]);
            return this.getClass().getAnnotation(Label.class).description();
        }
        return "";
    }

    public boolean isEnabled() {
        return this.enabled && this.isModuleEnabled();
    }

    public boolean isModuleEnabled() {
        return this.module.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledConfig(boolean enabled) {
        if (this.enabledConfig == null) {
            LogHelper.warn("Could not set enabled %s feature. The config option is null", this.name);
            return;
        }
        this.enabledConfig.set((Object)enabled);
    }

    public Module getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ForgeConfigSpec.Builder getBuilder() {
        return this.module.configBuilder;
    }

    public void loadConfigOptions() {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                String name;
                if (!field.isAnnotationPresent(Config.class)) continue;
                String description = "";
                if (!field.isAnnotationPresent(Label.class)) {
                    name = field.getAnnotation(Config.class).name();
                    if (name.isBlank()) {
                        name = Feature.fieldNameToConfigOption(field.getName());
                    }
                    description = field.getAnnotation(Config.class).description();
                } else {
                    name = field.getAnnotation(Label.class).name().isEmpty() ? Feature.fieldNameToConfigOption(field.getName()) : field.getAnnotation(Label.class).name();
                    description = field.getAnnotation(Label.class).description();
                }
                if (!Modifier.isStatic(field.getModifiers())) {
                    throw new UnsupportedOperationException("Failed to load %s field. The field is not static".formatted(field));
                }
                double min = field.getAnnotation(Config.class).min();
                double max = field.getAnnotation(Config.class).max();
                if (field.getType().isAssignableFrom(Double.class)) {
                    double defaultValue = (Double)field.get(null);
                    ConfigOption.DoubleOption doubleOption = new ConfigOption.DoubleOption(this.getBuilder(), name, description, defaultValue, min, max);
                    this.configOptions.put(field, doubleOption);
                    continue;
                }
                if (field.getType().isAssignableFrom(Integer.class)) {
                    int defaultValue = (Integer)field.get(null);
                    if (min == Double.MIN_VALUE) {
                        min = -2.147483648E9;
                    }
                    if (max == Double.MAX_VALUE) {
                        max = 2.147483647E9;
                    }
                    ConfigOption.IntOption intOption = new ConfigOption.IntOption(this.getBuilder(), name, description, defaultValue, (int)min, (int)max);
                    this.configOptions.put(field, intOption);
                    continue;
                }
                if (field.getType().isAssignableFrom(List.class)) {
                    List defaultValue = (List)field.get(null);
                    ConfigOption.StringListOption listOption = new ConfigOption.StringListOption(this.getBuilder(), name, description, defaultValue);
                    this.configOptions.put(field, listOption);
                    continue;
                }
                if (field.getType().isEnum()) {
                    Enum defaultValue = (Enum)field.get(null);
                    ConfigOption.EnumOption<Enum> enumOption = new ConfigOption.EnumOption<Enum>(this.getBuilder(), name, description, defaultValue);
                    this.configOptions.put(field, enumOption);
                    continue;
                }
                if (field.getType().isAssignableFrom(MinMax.class)) {
                    MinMax defaultValue = (MinMax)field.get(null);
                    MinMax.Config minMaxConfig = new MinMax.Config(this.getBuilder(), name, description, defaultValue, min, max);
                    this.configOptions.put(field, minMaxConfig);
                    continue;
                }
                if (field.getType().isAssignableFrom(Difficulty.class)) {
                    Difficulty defaultValue = (Difficulty)field.get(null);
                    Difficulty.Config difficultyConfig = new Difficulty.Config(this.getBuilder(), name, description, defaultValue, min, max);
                    this.configOptions.put(field, difficultyConfig);
                    continue;
                }
                if (field.getType().isAssignableFrom(Blacklist.class)) {
                    Blacklist defaultValue = (Blacklist)field.get(null);
                    Blacklist.Config blacklistConfig = new Blacklist.Config(this.getBuilder(), name, description, defaultValue);
                    this.configOptions.put(field, blacklistConfig);
                    continue;
                }
                if (field.getType().isAssignableFrom(IdTagMatcher.class)) {
                    IdTagMatcher defaultValue = (IdTagMatcher)field.get(null);
                    IdTagMatcher.Config idTagMatcherConfig = new IdTagMatcher.Config(this.getBuilder(), name, description, defaultValue);
                    this.configOptions.put(field, idTagMatcherConfig);
                    continue;
                }
                Object defaultValue = field.get(null);
                ConfigOption.GenericOption genericOption = new ConfigOption.GenericOption(this.getBuilder(), name, description, defaultValue);
                this.configOptions.put(field, genericOption);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Feature '%s'".formatted(this.name), e);
        }
    }

    public final void loadConfig() {
        if (this.canBeDisabled) {
            if (!this.description.isEmpty()) {
                this.module.configBuilder.comment(this.getDescription());
            }
            this.enabledConfig = this.module.configBuilder.define("Enable " + this.getName(), this.enabledByDefault);
        } else {
            this.enabledConfig = null;
        }
        this.pushConfig();
        this.loadConfigOptions();
        this.popConfig();
    }

    public void readConfig(ModConfigEvent event) {
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
        this.readConfigOptions();
    }

    public void postReadConfig(ModConfigEvent event) {
    }

    private void readConfigOptions() {
        if (this.configOptions.isEmpty()) {
            return;
        }
        String curField = "";
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Config.class)) continue;
                curField = this.configOptions.get(field).toString();
                field.set(this, this.configOptions.get(field).get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set config option for %s".formatted(curField), e);
        }
    }

    public void setConfigOption(String configName, Object value) {
        ConfigOption<?> configOption = this.getConfigOption(configName);
        if (configOption == null) {
            LogHelper.warn("Feature#setConfig failed as %s was not found".formatted(configName), new Object[0]);
            return;
        }
        configOption.set(value);
    }

    @Nullable
    public ConfigOption<?> getConfigOption(String configName) {
        Optional<ConfigOption> configOptionOptional = this.configOptions.values().stream().filter(configOption -> configOption.name.equals(configName)).findFirst();
        return configOptionOptional.orElse(null);
    }

    public void pushConfig() {
        if (!this.description.isEmpty()) {
            this.module.configBuilder.comment(this.getDescription());
        }
        this.module.configBuilder.push(this.getName());
    }

    protected void popConfig() {
        this.module.configBuilder.pop();
    }

    public void registerEvents() {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
            MinecraftForge.EVENT_BUS.register((Object)this);
            return;
        }
    }

    public static Feature get(Class<? extends Feature> feature) {
        return Module.getFeature(feature);
    }

    public static boolean isEnabled(Class<? extends Feature> feature) {
        return Feature.get(feature).isEnabled();
    }

    public static boolean isEnabled(String featureName) {
        return Module.getFeature(featureName).map(Feature::isEnabled).orElse(false);
    }

    public static String fieldNameToConfigOption(String camelCase) {
        camelCase = camelCase.replace('$', '.');
        CharSequence[] words = camelCase.split("(?<!^)(?=[A-Z])");
        String sentence = String.join((CharSequence)" ", words).toLowerCase();
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (int i = 0; i < sentence.length(); ++i) {
            char current = sentence.charAt(i);
            if (capitalizeNext && Character.isLetter(current)) {
                result.append(Character.toUpperCase(current));
                capitalizeNext = false;
            } else {
                result.append(current);
            }
            if (current != '.') continue;
            capitalizeNext = true;
        }
        return result.toString();
    }

    public String getDataKeyPath() {
        if (this.dataKeyPath != null) {
            return this.dataKeyPath;
        }
        String replaced = this.name.replace(" ", "_");
        this.dataKeyPath = replaced.toLowerCase().replaceAll("[^a-z0-9/._-]", "");
        return this.dataKeyPath;
    }

    public ResourceLocation createDataKey(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)this.module.getId().m_135827_(), (String)(this.getDataKeyPath() + "/" + key));
    }
}

