/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.placement;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.items.HypertubeItem;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.pedrorok.hypertube.utils.RayCastUtils;
import com.pedrorok.hypertube.utils.TubeUtils;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TubePlacement {
    static BlockPos hoveringPos;
    static boolean canPlace;
    static LerpedFloat animation;

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21205_();
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult == null) {
            return;
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        Item tubeItem = ((HypertubeBlock)ModBlocks.HYPERTUBE.get()).m_5456_();
        if (!stack.m_41720_().equals(tubeItem) && !(stack = player.m_21206_()).m_41720_().equals(tubeItem)) {
            return;
        }
        if (!stack.m_41790_()) {
            return;
        }
        Level level = player.m_9236_();
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos pos = bhr.m_82425_();
        BlockState hitState = level.m_8055_(pos);
        boolean hypertubeHitResult = hitState.m_60734_() instanceof ITubeConnection;
        if (hitState.m_60795_() || hypertubeHitResult) {
            hoveringPos = pos;
        } else {
            pos = pos.m_121945_(bhr.m_82434_());
        }
        SimpleConnection connectionFrom = ModDataComponent.decodeSimpleConnection(stack);
        animation.setValue(0.8);
        if (connectionFrom == null) {
            animation.setValue(0.0);
            return;
        }
        Direction finalDirection = RayCastUtils.getDirectionFromHitResult((Player)player, () -> hypertubeHitResult);
        SimpleConnection connectionTo = new SimpleConnection(pos, finalDirection);
        BezierConnection bezierConnection = BezierConnection.of(connectionFrom, connectionTo);
        ResponseDTO response = bezierConnection.getValidation();
        if (response.valid()) {
            response = TubeUtils.checkSurvivalItems((Player)player, (int)bezierConnection.distance(), true);
        }
        if (response.valid()) {
            response = TubeUtils.checkBlockCollision(level, bezierConnection);
        }
        if (response.valid() && hypertubeHitResult) {
            response = TubeUtils.checkClickedHypertube(level, pos, finalDirection.m_122424_());
        }
        animation.setValue(!response.valid() ? 0.2 : 0.8);
        canPlace = response.valid();
        bezierConnection.drawPath(animation, canPlace);
        if (!response.valid()) {
            MessageUtils.sendActionMessage((Player)player, (Component)response.getMessageComponent());
            return;
        }
        MessageUtils.sendActionMessage((Player)player, "");
    }

    public static boolean handleHypertubeClicked(ITubeConnectionEntity tubeEntity, Player player, SimpleConnection simpleConnection, BlockPos pos, Direction direction, Level level, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(simpleConnection.pos());
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.no_other_tube_found").m_130940_(ChatFormatting.RED));
            return false;
        }
        ITubeConnectionEntity otherConnection = (ITubeConnectionEntity)blockEntity;
        if (!otherConnection.hasConnectionAvailable() || !tubeEntity.hasConnectionAvailable()) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.cant_conn_tubes").m_130940_(ChatFormatting.RED));
            return false;
        }
        BezierConnection connection = new BezierConnection(simpleConnection, new SimpleConnection(pos, direction.m_122424_()));
        ResponseDTO validation = connection.getValidation();
        if (validation.valid()) {
            validation = TubeUtils.checkSurvivalItems(player, (int)connection.distance(), true);
        }
        if (validation.valid()) {
            validation = TubeUtils.checkBlockCollision(level, connection);
        }
        if (validation.valid()) {
            validation = TubeUtils.checkClickedHypertube(level, pos, direction);
        }
        if (!validation.valid()) {
            MessageUtils.sendActionMessage(player, (Component)validation.getMessageComponent().m_130940_(ChatFormatting.RED), true);
            return false;
        }
        TubeUtils.checkSurvivalItems(player, (int)connection.distance(), false);
        if (level.f_46443_) {
            connection.drawPath(LerpedFloat.linear().startWithValue(0.0), true);
        }
        tubeEntity.setConnection(connection.getFromPos(), direction);
        otherConnection.setConnection(connection, connection.getFromPos().direction());
        MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.success_conn").m_130940_(ChatFormatting.GREEN), true);
        player.m_5496_(SoundEvents.f_12013_, 1.0f, 1.0f);
        HypertubeItem.clearConnection(player.m_21120_(InteractionHand.MAIN_HAND));
        return true;
    }

    public static void tickPlayerServer(@NotNull Player player) {
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        Level level = player.m_9236_();
        if (!(itemInHand.m_41720_() instanceof HypertubeItem)) {
            return;
        }
        if (!itemInHand.m_41790_()) {
            return;
        }
        SimpleConnection connection = ModDataComponent.decodeSimpleConnection(itemInHand);
        if (connection == null) {
            return;
        }
        if (!(level.m_7702_(new BlockPos((Vec3i)connection.pos())) instanceof ITubeConnectionEntity)) {
            HypertubeItem.clearConnection(itemInHand);
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.conn_cleared_invalid_block").m_130940_(ChatFormatting.RED));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        ItemStack mainHandItem = Minecraft.m_91087_().f_91074_.m_21205_();
        HypertubeBlock hypertubeBlock = (HypertubeBlock)ModBlocks.HYPERTUBE.getUnchecked();
        if (hypertubeBlock == null) {
            return;
        }
        if (!mainHandItem.m_150930_(hypertubeBlock.m_5456_())) {
            return;
        }
        if (!mainHandItem.m_41790_()) {
            return;
        }
        SimpleConnection connection = ModDataComponent.decodeSimpleConnection(mainHandItem);
        if (connection == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockState blockState = mc.f_91073_.m_8055_(connection.pos());
        if (!(blockState.m_60734_() instanceof HypertubeBlock)) {
            return;
        }
        HypertubeBlock block = (HypertubeBlock)blockState.m_60734_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110504_());
        ms.m_85836_();
        ms.m_85837_((double)connection.pos().m_123341_() - camera.f_82479_, (double)connection.pos().m_123342_() - camera.f_82480_, (double)connection.pos().m_123343_() - camera.f_82481_);
        TrackBlockOutline.renderShape((VoxelShape)block.getShape(blockState), (PoseStack)ms, (VertexConsumer)vb, (Boolean)canPlace);
        ms.m_85849_();
    }

    static {
        canPlace = false;
        animation = LerpedFloat.linear().startWithValue(0.0);
    }
}

