/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.connection.interfaces;

import com.mojang.serialization.DynamicOps;
import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.core.connection.BezierConnection;
import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface ITubeConnectionEntity {
    default public IConnection getConnection(CompoundTag tag, String key) {
        try {
            return (IConnection)BezierConnection.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(key)).get().orThrow();
        }
        catch (Exception ignored) {
            return (IConnection)SimpleConnection.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(key)).get().orThrow();
        }
    }

    default public void writeConnection(CompoundTag tag, Tuple<IConnection, String> ... connections) {
        for (Tuple<IConnection, String> connection : connections) {
            if (connection.m_14418_() == null) continue;
            this.writeConnection(tag, (IConnection)connection.m_14418_(), (String)connection.m_14419_());
        }
    }

    private void writeConnection(CompoundTag tag, IConnection connection, String key) {
        if (connection instanceof SimpleConnection) {
            SimpleConnection simpleConnection = (SimpleConnection)connection;
            tag.m_128365_(key, (Tag)SimpleConnection.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)simpleConnection).get().orThrow());
        } else {
            tag.m_128365_(key, (Tag)BezierConnection.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)((BezierConnection)connection)).get().orThrow());
        }
    }

    @Nullable
    public IConnection getConnectionInDirection(Direction var1);

    @Nullable
    public IConnection getThisConnectionFrom(SimpleConnection var1);

    public boolean hasConnectionAvailable();

    public boolean isConnected();

    public void setConnection(IConnection var1, Direction var2);

    public void clearConnection(IConnection var1);

    public int blockBroken();

    default public int blockBroken(Level level, IConnection connection, BlockPos selfPos) {
        BlockEntity otherBlock;
        int toDrop = 0;
        BezierConnection thisEntranceConnection = connection.getThisEntranceConnection(level);
        if (thisEntranceConnection != null) {
            toDrop += (int)thisEntranceConnection.distance();
        }
        IConnection connectionToClear = null;
        BlockPos otherBlockPos = null;
        if (connection instanceof BezierConnection) {
            BezierConnection bezier = (BezierConnection)connection;
            SimpleConnection connectionTo = bezier.getToPos();
            SimpleConnection connectionFrom = bezier.getFromPos();
            if (connectionTo.pos().equals((Object)selfPos)) {
                connectionToClear = connection;
                otherBlockPos = connectionFrom.pos();
            } else if (connectionFrom.pos().equals((Object)selfPos)) {
                connectionToClear = connectionFrom;
                otherBlockPos = connectionTo.pos();
            }
        } else if (connection instanceof SimpleConnection) {
            SimpleConnection simple = (SimpleConnection)connection;
            if (simple.pos().equals((Object)selfPos)) {
                try {
                    throw new TubeConnectionException("SimpleConnection should not be used here, use BezierConnection instead.", connection);
                }
                catch (TubeConnectionException e) {
                    HypertubeMod.LOGGER.error(e.getMessage());
                    return 0;
                }
            }
            otherBlockPos = simple.pos();
            connectionToClear = thisEntranceConnection;
        }
        if (connectionToClear != null && (otherBlock = level.m_7702_(otherBlockPos)) instanceof ITubeConnectionEntity) {
            ITubeConnectionEntity tubeConnection = (ITubeConnectionEntity)otherBlock;
            tubeConnection.clearConnection(connectionToClear);
        }
        return toDrop;
    }

    public List<Direction> getFacesConnectable();

    public List<IConnection> getConnections();

    public boolean wrenchClicked(Direction var1);

    @Nullable
    public Vec3 getExitDirection();
}

