/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.blocks.HyperEntranceBlock;
import com.pedrorok.hypertube.blocks.blockentities.TubeBlockEntity;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.registry.ModParticles;
import com.pedrorok.hypertube.registry.ModSounds;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class ActionTubeBlockEntity
extends TubeBlockEntity {
    private static final float RADIUS = 1.0f;
    protected final UUID tubeSoundId = UUID.randomUUID();

    public ActionTubeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void spawnSuctionParticle(Level level, BlockPos blockPos, Direction face) {
        face = face.m_122424_();
        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
        RandomSource rand = level.m_213780_();
        Vec3 faceNormal = Vec3.m_82528_((Vec3i)face.m_122436_());
        double spread = 0.5;
        Vec3 tangentA = switch (face.m_122434_()) {
            case Direction.Axis.Y, Direction.Axis.Z -> new Vec3(1.0, 0.0, 0.0);
            default -> new Vec3(0.0, 1.0, 0.0);
        };
        Vec3 tangentB = faceNormal.m_82537_(tangentA).m_82541_();
        double offsetA = (rand.m_188500_() - 0.5) * 2.0 * spread;
        double offsetB = (rand.m_188500_() - 0.5) * 2.0 * spread;
        Vec3 randomOffset = tangentA.m_82490_(offsetA).m_82549_(tangentB.m_82490_(offsetB));
        Vec3 start = center.m_82549_(faceNormal.m_82490_((double)(1.0f + level.f_46441_.m_188501_()))).m_82549_(randomOffset);
        Vec3 motion = center.m_82546_(start).m_82541_().m_82490_(0.05);
        level.m_7106_((ParticleOptions)ModParticles.SUCTION_PARTICLE.get(), start.f_82479_, start.f_82480_, start.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    protected void playOpenCloseSound(boolean open) {
        RandomSource random = this.f_58857_.f_46441_;
        float pitch = 0.4f + random.m_188501_() * 0.4f;
        this.f_58857_.m_5594_(null, this.m_58899_(), open ? (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_OPEN.get() : (SoundEvent)ModSounds.HYPERTUBE_ENTRANCE_CLOSE.get(), SoundSource.BLOCKS, 0.2f, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playClientEffects(TubeSoundManager.TubeAmbientSound sound) {
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        boolean isOpen = (Boolean)state.m_61143_((Property)HyperEntranceBlock.OPEN);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 source = pos.m_252807_();
        Vec3 listener = player.m_20182_();
        Vec3 worldDirection = source.m_82546_(listener).m_82541_();
        Vec3 forward = player.m_20154_().m_82541_();
        Vec3 up = player.m_20289_(1.0f).m_82541_();
        Vec3 right = forward.m_82537_(up).m_82541_();
        double x = worldDirection.m_82526_(right);
        double y = worldDirection.m_82526_(up);
        double z = worldDirection.m_82526_(forward);
        Vec3 rotatedDirection = new Vec3(x, y, z).m_82541_();
        double distance = player.m_20238_(source);
        if (isOpen) {
            this.spawnSuctionParticle(this.f_58857_, pos, (Direction)state.m_61143_((Property)HyperEntranceBlock.FACING));
        }
        sound.enableClientPlayerSound((Entity)player, rotatedDirection, distance, isOpen);
    }

    @Nullable
    protected LivingEntity getInRangeLivingEntities(ServerLevel level, Vec3 centerPos, Direction facing) {
        Vec3 checkPos = centerPos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122424_().m_122436_()));
        return level.m_45982_(level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)checkPos, (double)1.5, (double)1.5, (double)1.5), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.m_6095_())), TargetingConditions.m_148353_().m_148355_(), null, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
    }

    @Nullable
    protected LivingEntity getNearbyLivingEntities(ServerLevel level, Vec3 centerPos) {
        return level.m_45982_(level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)centerPos, (double)6.0, (double)6.0, (double)6.0), entity -> TravelConstants.TRAVELLER_ENTITIES.contains(entity.m_6095_())), TargetingConditions.m_148353_().m_148355_(), null, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_);
    }

    protected boolean isTubeClosed(boolean canOpen, boolean isOpen) {
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        if (!canOpen) {
            if (isOpen) {
                this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
                this.playOpenCloseSound(false);
            }
            return true;
        }
        if (!isOpen) {
            this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)HyperEntranceBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
            this.playOpenCloseSound(true);
        }
        return false;
    }

    public void remove() {
        if (this.f_58857_.f_46443_) {
            this.removeClient();
        }
        super.remove();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeClient() {
        TubeSoundManager.getAmbientSound(this.tubeSoundId).stopSound();
        TubeSoundManager.removeAmbientSound(this.tubeSoundId);
    }
}

